
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <sched.h>

int sysrq_fd;
int success;
char stack[64*1024];

int monitor(void *p)
{
	usleep(1000 * 1000);
	if (!success)
		write(sysrq_fd, "t", 1);
	return 0;
}

int main(int argc, char *argv[])
{
	int fd;
	char buf[1024 * 1024];

	memset(buf, 0, sizeof(buf));	/* Fault it in */
	memset(stack, 0, sizeof(stack));

	sysrq_fd = open("/proc/sysrq-trigger", O_RDWR);
	if (sysrq_fd < 0) {
		perror("open sysrq");
		exit(1);
	}

	if (argc != 2) {
		fprintf(stderr, "usage: %s filename\n", argv[0]);
		exit(1);
	}

	if (clone(monitor, stack+sizeof(stack),
			CLONE_FILES|CLONE_FS|CLONE_VM, NULL) < 0) {
		perror("clone");
		exit(1);
	}
	fd = open(argv[1], O_RDONLY);
	if (fd < 0) {
		perror("open");
		exit(1);
	}
	read(fd, buf, sizeof(buf));
	success = 1;
	exit(0);
}
