#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <time.h>
#include <sys/mman.h>
#include <sys/signal.h>
#include <sys/stat.h>

int fd;
char *mapped_mem;
char *progname;
char *filename;
loff_t size = 100000;

void open_file()
{
	fd = open(filename, O_RDWR, 0666);
	if (fd < 0) {
		fprintf(stderr, "%s: Cannot open `%s': %s\n",
			progname, filename, strerror(errno));
		exit(1);
	}
}

void mmap_file(void)
{
	mapped_mem = mmap(0, size, PROT_READ|PROT_WRITE, MAP_SHARED, fd, 0);
	if (mapped_mem == MAP_FAILED) {
		perror("mmap");
		exit(1);
	}
}

void usage(void)
{
	fprintf(stderr, "Usage: %s filename\n", progname);
	exit(1);
}

int main(int argc, char *argv[])
{
	int c;

	progname = argv[0];
	while ((c = getopt(argc, argv, "")) != -1) {
		switch (c) {
		default:
			usage();
			break;
		}
	}

	if (optind == argc)
		usage();
	filename = argv[optind++];
	if (optind != argc)
		usage();

	open_file();

	mmap_file();
	madvise(mapped_mem, 100000, MADV_WILLNEED);
	exit(0);
}

