/*
 * Demonstrate glibc's malloc()/free() problem.
 *
 * Jakub Jelinek <jakub@redhat.com>
 */

#include <pthread.h>
#include <stdlib.h>
#include <sys/mman.h>
#include <unistd.h>

void *tf(void *arg)
{
	size_t ps = sysconf (_SC_PAGE_SIZE);
	void *p = mmap(NULL, 128 * ps, PROT_READ | PROT_WRITE,
			MAP_PRIVATE | MAP_ANONYMOUS, -1, 0);

	if (p == MAP_FAILED)
		exit(1);

	int i;
	for (i = 0; i < 1000; i++) {
		/* Pretend to use the buffer.  */
		char *q, *r = (char *) p + 128 * ps;
		size_t s;

		for (q = (char *) p; q < r; q += ps)
			*q = 1;
		for (s = 0, q = (char *) p; q < r; q += ps)
			s += *q;
		/* Free it.  Replace this mmap with
		  madvise (p, 128 * ps, MADV_THROWAWAY) when implemented.  */
		if (mmap(p, 128 * ps, PROT_NONE,
			MAP_PRIVATE | MAP_ANONYMOUS | MAP_FIXED, -1, 0) != p)
		exit(2);
		/* And immediately malloc again.  This would then be deleted. */
		if (mprotect (p, 128 * ps, PROT_READ | PROT_WRITE))
			exit(3);
	}
	return NULL;
}

int main(void)
{
	pthread_t th[32];
	int i;

	for (i = 0; i < 32; i++)
		if (pthread_create(&th[i], NULL, tf, NULL))
			exit(4);
	for (i = 0; i < 32; i++)
		pthread_join(th[i], NULL);
	return 0;
}
