/*
 * ext3_add-blocks
 */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <getopt.h>

#include <sys/ioctl.h>
#include <sys/fcntl.h>

#ifndef EXT3_IOC_ADD_BLOCKS
#define        EXT3_IOC_ADD_BLOCKS             _IOW('f', 5, long)

struct ext3_add_blocks_args {
	u_int64_t start_byte;
	u_int64_t nbytes;
};
#endif	

int verbose;
char *progname;
loff_t start_byte;
loff_t nbytes;
char *filename;
int fd;

static void usage(void)
{
	fprintf(stderr, "Usage: ext3_add_blocks start_byte nbytes filename\n");
	exit(1);
}

int main(int argc, char *argv[])
{
	int c;
	struct ext3_add_blocks_args aba;

	progname = argv[0];
	while ((c = getopt(argc, argv, "vn:t:")) != -1) {
		switch (c) {
		case 'v':
			verbose++;
			break;
		default:
			usage();
		}
	}

	if (optind == argc)
		usage();
	sscanf(argv[optind++], "%Ld", &start_byte);
	if (optind == argc)
		usage();
	sscanf(argv[optind++], "%Ld", &nbytes);
	if (optind == argc)
		usage();
	filename = argv[optind++];
	if (optind != argc)
		usage();

	fd = open(filename, O_RDWR);
	if (fd < 0) {
		perror("open");
		exit(1);
	}

	aba.start_byte = start_byte;
	aba.nbytes = nbytes;
	if (ioctl(fd, EXT3_IOC_ADD_BLOCKS, &aba)) {
		perror("ioctl");
		exit(1);
	}
	exit(0);
}
