#include <ccan/err/err.h>
#include <ccan/net/net.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <unistd.h>

static bool read_to_one(int fd)
{
	char packet[10000];
	int len, so_far = 0;

	while ((len = read(fd, packet + so_far, sizeof(packet) - so_far)) > 0) {
		so_far += len;
		if (packet[so_far - 1] == 1)
			return true;
	}
	return false;
}

int main(int argc, char *argv[])
{
	const char *server = argc > 1 ? argv[1]: "ozlabs.org";
	const char *service = argc > 2 ? argv[2]: "31717";
	struct addrinfo *addri;
	int fd;
	int val = 1;
	socklen_t optlen = sizeof(val);
	char ack = 1;

	addri = net_client_lookup(server, service, AF_UNSPEC, SOCK_STREAM);
	if (!addri)
		err(1, "Looking up %s service %s", server, service);

	fd = net_connect(addri);
	if (fd < 0)
		err(1, "Connecting to %s service %s", server, service);

	if (setsockopt(fd, IPPROTO_TCP, TCP_NODELAY, &val, optlen) != 0)
		err(1, "Turning off nagle");

	while (read_to_one(fd))
		if (write(fd, &ack, 1) != 1)
			break;

	return 0;
}
