#include <ccan/err/err.h>
#include <ccan/time/time.h>
#include <ccan/net/net.h>
#include <ccan/read_write_all/read_write_all.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/select.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <string.h>
#include <stdio.h>

static struct timespec time_packet(int fd, unsigned int len)
{
	struct timespec start;
	char pkt[len], ack;

	memset(pkt, 0, len - 1);
	pkt[len-1] = 1;

	start = time_now();
	if (!write_all(fd, pkt, len))
		err(1, "Writing packet size %u", len);
	if (!read_all(fd, &ack, 1))
		err(1, "Reading packet reply");
	return time_sub(time_now(), start);
}

int main(int argc, char *argv[])
{
	const char *service = argv[1] ?: "31717";
	struct addrinfo *addri;
	int fds[2], num_fds, in, max_fd = -1;
	unsigned int i, n;
	int val = 1;
	socklen_t optlen = sizeof(val);
	fd_set fdset;

	addri = net_server_lookup(service, AF_UNSPEC, SOCK_STREAM);
	if (!addri)
		err(1, "Looking up service %s", service);

	num_fds = net_bind(addri, fds);
	if (num_fds < 0)
		err(1, "Binding to %s", service);

	FD_ZERO(&fdset);
	for (i = 0; i < num_fds; i++) {
		FD_SET(fds[i], &fdset);
		if (fds[i] > max_fd)
			max_fd = fds[i];
	}

	select(max_fd+1, &fdset, NULL, NULL, NULL);
	for (i = 0; !FD_ISSET(fds[i], &fdset); i++) {
		if (i == num_fds)
			err(1, "Select failed");
	}

	in = accept(fds[i], NULL, NULL);
	if (in < 0)
		err(1, "Accepting connection");

	if (setsockopt(in, IPPROTO_TCP, TCP_NODELAY, &val, optlen) != 0)
		err(1, "Turning off nagle");

	for (i = 0; i < 20; i++) {
		for (n = 1; n < 10000; n += 100) {
			struct timespec t = time_packet(in, n);
			printf("%i, %lu\n", n, (unsigned long)time_to_usec(t));
		}
	}

	return 0;
}
	

