/* Simple backwards compat code to exec old version */

#ifndef CONFIG_NO_BACKWARDS_COMPAT
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <asm/unistd.h>

_syscall5(int, query_module, const char *, name, int, which,
	  void *, buf, size_t, bufsize, size_t *, ret);

static void try_old_version(const char *progname, char *argv[])
{
	struct stat buf;
	char oldname[strlen(progname) + sizeof(".old")];

	sprintf(oldname, "%s.old", progname);

	/* In case we're called foo.old already, don't recurse. */
	if (strstr(argv[0], oldname))
		return;

	/* 2.2 and 2.4 have a syscall.  2.0 doesn't, but does have
           /proc/ksyms */
	if (query_module(NULL, 0, NULL, 0, NULL) == 0
	    || stat("/proc/ksyms", &buf) == 0) {
		execvp(oldname, argv);
		fprintf(stderr,
			"Kernel requires old %s, but couldn't run %s: %s\n",
			progname, oldname, strerror(errno));
		exit(2);
	}
}
#else /* CONFIG_NO_BACKWARDS_COMPAT */
static inline void try_old_version(const char *progname, char *argv[])
{
}
#endif /* !CONFIG_NO_BACKWARDS_COMPAT */

