Simple benchmark for jhash.

Includes two out-of-line variants for easy examination of asm.

Signed-off-by: Rusty Russell <rusty@rustcorp.com.au>
---
 kernel/Makefile     |    2 -
 kernel/jhashbench.c |   69 ++++++++++++++++++++++++++++++++++++++++++++++++++++
 2 files changed, 70 insertions(+), 1 deletion(-)

diff -r 91edecd8c75a kernel/Makefile
--- a/kernel/Makefile	Mon Aug 04 13:55:38 2008 +1000
+++ b/kernel/Makefile	Mon Aug 04 13:55:48 2008 +1000
@@ -9,7 +9,7 @@ obj-y     = sched.o fork.o exec_domain.o
 	    rcupdate.o extable.o params.o posix-timers.o \
 	    kthread.o wait.o kfifo.o sys_ni.o posix-cpu-timers.o mutex.o \
 	    hrtimer.o rwsem.o nsproxy.o srcu.o semaphore.o \
-	    notifier.o ksysfs.o pm_qos_params.o sched_clock.o
+	    notifier.o ksysfs.o pm_qos_params.o sched_clock.o jhashbench.o
 
 CFLAGS_REMOVE_sched.o = -mno-spe
 
diff -r 91edecd8c75a kernel/jhashbench.c
--- /dev/null	Thu Jan 01 00:00:00 1970 +0000
+++ b/kernel/jhashbench.c	Mon Aug 04 13:55:48 2008 +1000
@@ -0,0 +1,69 @@
+#include <linux/types.h>
+#include <linux/jhash.h>
+#include <linux/init.h>
+#include <linux/slab.h>
+#include <linux/ktime.h>
+
+#define BENCHSIZE 1024
+
+u32 hashcode(unsigned int a, unsigned int b, unsigned int c, unsigned int d)
+{
+	return jhash_3words(a,b,c,d);
+}
+
+u32 hash(const void *key, u32 length, u32 initval)
+{
+	return jhash(key, length, initval);
+}
+
+int jhashbench(void)
+{
+	unsigned int i;
+	u32 res;
+	struct timespec start, end;
+	char *p = kmalloc(BENCHSIZE * 2, GFP_KERNEL);
+
+	for (i = 0; i < BENCHSIZE; i++)
+		p[i] = i;
+
+	res = jhash(p, BENCHSIZE, 0);
+	for (i = 1; i < BENCHSIZE; i++) {
+		u32 r;
+		memmove(p+i, p+i-1, BENCHSIZE);
+		r = jhash(p+i, BENCHSIZE, 0);
+		if (r != res) {
+			printk("jhash: at %i = %x, not %x\n", i, r, res);
+			return 0;
+		}
+	}
+	printk("jhash: all gave %u\n", res);
+
+	getnstimeofday(&start);
+	for (i = 0; i < 10000000; i++)
+		res = jhash(p, BENCHSIZE, res);
+	getnstimeofday(&end);
+	printk("jhash: %u bytes 10 000 000 times = %lluns\n",
+	       BENCHSIZE, ktime_to_ns(ktime_sub(timespec_to_ktime(end),
+						timespec_to_ktime(start))));
+
+	getnstimeofday(&start);
+	for (i = 0; i < 10000000; i++)
+		res = jhash_3words(i, p[0], p[1], res);
+	getnstimeofday(&end);
+	printk("jhash_3words: 10 000 000 times = %lluns\n",
+	       ktime_to_ns(ktime_sub(timespec_to_ktime(end),
+				     timespec_to_ktime(start))));
+
+	getnstimeofday(&start);
+	for (i = 0; i < 10000000; i++)
+		res = jhash2((u32 *)p, BENCHSIZE/4, res);
+	getnstimeofday(&end);
+	printk("jhash2: %u words 10 000 000 times = %lluns\n",
+	       BENCHSIZE/4,
+	       ktime_to_ns(ktime_sub(timespec_to_ktime(end),
+				     timespec_to_ktime(start))));
+
+	printk("jhash: final result %u\n", res);
+	return 0;
+}
+__initcall(jhashbench);
