/**********************************************************************
   Copyright (C) Christopher Yeoh <cyeoh@samba.org> 2005
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**********************************************************************/
#include "StartGameDialog.H"

#include <qvbox.h>
#include <qhbox.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qlabel.h>

StartGameDialog::StartGameDialog(QWidget *Parent, const char *Name)
    : QDialog(Parent, Name)
{
    QVBoxLayout *vb = new QVBoxLayout(this);

    QHBox *hbh = new QHBox(this);
    new QLabel("Hostname", hbh);
    hostnameEntry = new QLineEdit("localhost", hbh);
    vb->addWidget(hbh);

    QHBox *ubh = new QHBox(this);
    new QLabel("Username", ubh);
    usernameEntry = new QLineEdit("qt_spellcast", ubh);
    vb->addWidget(ubh);

    obsButton = new QRadioButton("Join as observer", this, "obsButton");
    vb->addWidget(obsButton);

    QHBox *buttonBox = new QHBox(this);
    QPushButton *OkButton = new QPushButton("OK", buttonBox);
    QPushButton *CancelButton = new QPushButton("Cancel", buttonBox);
    vb->addWidget(buttonBox);

    connect(OkButton, SIGNAL(clicked()), this, SLOT(accept()));
    connect(CancelButton, SIGNAL(clicked()), this, SLOT(reject()));
}

QString
StartGameDialog::GetHostName() const
{
    return hostnameEntry->text();
}

QString
StartGameDialog::GetUsername() const
{
    return usernameEntry->text();
}

bool
StartGameDialog::IsObserver() const
{
    return obsButton->isOn();
}
