/**********************************************************************
   Copyright (C) Christopher Yeoh <cyeoh@samba.org> 2005
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**********************************************************************/
#include "GestureHistoryDisplay.H"

#include <assert.h>
#include <qlabel.h>

GestureHistoryDisplay::GestureHistoryDisplay(QWidget *Parent)
    : QHBox(Parent)
{
}

void
GestureHistoryDisplay::AddPlayer(const QString &Name, int Id)
{
    PlayerToDisplay ptd;
    ptd.name = Name;

    ptd.vb = new QVBox(this);
    ptd.label = new QLabel(Name, ptd.vb);
    ptd.gestureDisplay = new PlayerGestures(ptd.vb);
    ptd.vb->show();
    players[Id] = ptd;

}

void
GestureHistoryDisplay::AddGestures(int PlayerId, Gesture Left, Gesture Right)
{
    assert(players.find(PlayerId)!=players.end());

    players[PlayerId].gestureDisplay->AddGestures(Left, Right);
}

void
GestureHistoryDisplay::Clear()
{
    map<int, PlayerToDisplay>::iterator player;
    for (player=players.begin(); player!=players.end(); player++) {
	player->second.gestureDisplay->Hide();
	player->second.label->hide();
    }
    players.clear();

}
