/**********************************************************************
   Copyright (C) Christopher Yeoh <cyeoh@samba.org> 2005
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**********************************************************************/
#include "PlayerInput.H"
#include <qcursor.h>
#include <stdio.h>

PlayerInput::PlayerInput(QWidget *Parent, int Margin, int Spacing,
			 const char *Name)
    : QHBoxLayout(Parent, Margin, Spacing, Name)
{
    selectButton = new QPushButton(Parent);
    confirmButton = new QPushButton(Parent);
    confirmState = false;
    confirmButton->setEnabled(confirmState);
    selectButton->setText("Please Wait....");
    confirmButton->setText("Confirm");
    selectMenu = new QPopupMenu(Parent, "SelectPopupMenu");

    addWidget(selectButton);
    addWidget(confirmButton);

    connect(selectMenu, SIGNAL(activated(int)), 
	    this, SLOT(InputSelected(int)));
    connect(selectButton, SIGNAL(pressed()), this, SLOT(SelectButtonPushed()));
    connect(confirmButton, SIGNAL(pressed()), 
	    this, SLOT(ConfirmButtonPushed()));
}

void
PlayerInput::SetStateLabel(const QString &Label)
{
    selectLabel = Label;
    selectButton->setText(selectLabel);
}

void
PlayerInput::SetConfirmState(bool State)
{
    confirmState = State;
    confirmButton->setEnabled(confirmState);
}

void
PlayerInput::SetList(const vector<QString> &List)
{
    haveList = true;
    selectList = List;
    vector<QString>::const_iterator listItem;
    int i=0;
    selectMenu->clear();
    for (listItem=List.begin(); listItem!=List.end(); listItem++) {
	selectMenu->insertItem(*listItem, i++);
    }
    selectedItem = -1;
}

void
PlayerInput::SetList(const map<QString, int> &List)
{
    haveList = false;
    selectMap = List;
    map<QString, int>::const_iterator listItem;
    selectMenu->clear();
    for (listItem=List.begin(); listItem!=List.end(); listItem++) {
	selectMenu->insertItem(listItem->first, listItem->second);
    }
    selectedItem = -1;
}

void
PlayerInput::InputSelected(int Id)
{
    selectedItem = Id;
    QString newLabel = selectLabel + " - ";
    if (haveList) {
	newLabel += selectList[Id];
    } else {
	map<QString, int>::const_iterator entry;
	for (entry=selectMap.begin(); entry != selectMap.end(); entry++) {
	    if (entry->second == Id) {
		newLabel += entry->first;
		break;
	    }
	}
    }
    selectButton->setText(newLabel);
    SetConfirmState(true);
}

void 
PlayerInput::SelectButtonPushed()
{
    selectMenu->exec(QCursor::pos());
}

void 
PlayerInput::ConfirmButtonPushed()
{
    emit itemSelected(selectedItem);
}
