/**********************************************************************
   Copyright (C) Christopher Yeoh <cyeoh@samba.org> 2005
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**********************************************************************/
#include <assert.h>

#include "PlayerStatus.H"

PlayerStatus::PlayerStatus(QWidget *Parent, const char *Name) 
    : QTextEdit(Parent, Name)
{
    setReadOnly(true);
}

void
PlayerStatus::updateStatus(SCClient *SC)
{
    assert(SC->haveAllCreatureInfo());

    vector<int> creatures;
    vector<int>::const_iterator creature;
    SC->getAllCreatureIDs(&creatures);
    QString newText;

    for (creature=creatures.begin(); creature!=creatures.end();
	 creature++) {
	updateForCreature(SC, &newText, *creature);
	newText += "\n";
    }
    setText(newText);
}

void
PlayerStatus::updateForCreature(SCClient *SC, QString *OutputText, 
				int CreatureID)
{
    SCClient::CreatureState creature;
    SC->getCreatureInfo(CreatureID, &creature);

    QString playerText;
    playerText.sprintf("Name: %s\nHitPoints: %i\nState: %i\n",
		       creature.name.c_str(),
		       creature.hitPoints,
		       creature.state);
    if (creature.owner!=0) {
	QString newText;
	SCClient::CreatureState owner;
	SC->getCreatureInfo(creature.owner, &owner);
	newText.sprintf("Owner Name: %s\n", owner.name.c_str());
	playerText += newText;
    }
    *OutputText += playerText;
}
