/**********************************************************************
   Copyright (C) Christopher Yeoh <cyeoh@samba.org> 2005
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**********************************************************************/
#include "StartGameDialog.H"

#include <qlayout.h>
#include <qpushbutton.h>
#include <qlabel.h>

StartGameDialog::StartGameDialog(QWidget *Parent, const char *Name)
    : QDialog(Parent, Name)
{
    QVBoxLayout *vb = new QVBoxLayout(this);

    QHBoxLayout *hbh = new QHBoxLayout(vb);
    hostnameEntry = new QLineEdit("localhost", this);
    hbh->addWidget(new QLabel("Hostname", this));
    hbh->addWidget(hostnameEntry);

    QHBoxLayout *ubh = new QHBoxLayout(vb);
    usernameEntry = new QLineEdit("qt_spellcast", this);
    ubh->addWidget(new QLabel("Username", this));
    ubh->addWidget(usernameEntry);

    obsButton = new QRadioButton("Join as observer", this, "obsButton");

    QHBoxLayout *buttonLayout = new QHBoxLayout(vb);
    QPushButton *OkButton = new QPushButton("OK", this);
    QPushButton *CancelButton = new QPushButton("Cancel", this);
    buttonLayout->addWidget(OkButton);
    buttonLayout->addWidget(CancelButton);

    vb->addLayout(hbh);
    vb->addLayout(ubh);
    vb->addWidget(obsButton);
    vb->addLayout(buttonLayout);

    connect(OkButton, SIGNAL(clicked()), this, SLOT(accept()));
    connect(CancelButton, SIGNAL(clicked()), this, SLOT(reject()));
}

QString
StartGameDialog::GetHostName() const
{
    return hostnameEntry->text();
}

QString
StartGameDialog::GetUsername() const
{
    return usernameEntry->text();
}

bool
StartGameDialog::IsObserver() const
{
    return obsButton->isOn();
}
