#ifndef _MESSAGE_H
#define _MESSAGE_H

/**********************************************************************
   Copyright (C) Christopher Yeoh <cyeoh@samba.org> 2005
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**********************************************************************/

struct Message {
    int header;
    unsigned int length;
    int command;
    char data[0];
    
    // Check header and footer values are what expected
    bool Ok() const;
    unsigned int dataLength() const; // Ignoring footer
    
    
    // Create message, allocating memory necessary
    static Message *createMessage(int Command, int DataSize);

    // Convert appropriate bits to network byte order
    static void ConvertToNetworkByteOrder(Message *Msg);

    // Convert appropriate bits to host byte order
    static void ConvertToHostByteOrder(Message *Msg);

    
private:
    static const int headerValue;
    static const int footerValue;
};

#endif
