/**********************************************************************
   Copyright (C) Christopher Yeoh <cyeoh@samba.org> 2005
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**********************************************************************/
#include "LogFile.H"
#include <assert.h>

LogFile::LogLevel LogFile::logLevel = LogFile::NORMAL;
FILE * LogFile::logFile = NULL;
bool LogFile::initLogLevelStrings = false;
char *LogFile::logLevelStrings[4];

bool
LogFile::OpenLog(const string &Filename) 
{
    if (!initLogLevelStrings) {
	logLevelStrings[NORMAL] = "NORMAL";
	logLevelStrings[DEBUG1] = "DEBUG1";
	logLevelStrings[DEBUG2] = "DEBUG2";
	logLevelStrings[DEBUG3] = "DEBUG3";
	initLogLevelStrings = true;
    }

    if (logFile) LogFile::CloseLog();

    logFile = fopen(Filename.c_str(), "a");
    if (logFile==NULL) {
	return false;
    } else {
	return true;
    }
}

void
LogFile::SetLogLevel(LogLevel Level) 
{
    logLevel = Level;
}

void
LogFile::Log(const char *Message, ...) 
{
    va_list ap;
    va_start(ap, Message);
    LogToFile(NORMAL, Message, &ap);
}

void
LogFile::Log(LogLevel Level, const char *Message, ...)
{
    if (Level<=logLevel) {
	va_list ap;
	va_start(ap, Message);
	LogToFile(Level, Message, &ap);
    }
}

bool
LogFile::CloseLog() 
{
    assert(logFile);
    return fclose(logFile) == 0;
}

void
LogFile::LogToFile(LogLevel Level, const char *Message, va_list *Args)
{
    assert(logFile);
    static char timeChar[100];

    time_t currentTime = time(NULL);

    strftime(timeChar, 100, "%Y%m%d %H:%M", localtime(&currentTime));
    timeChar[99] = 0;

    fprintf(logFile, "%s [%s]: ", timeChar, logLevelStrings[Level]);
    vfprintf(logFile, Message, *Args);
    fprintf(logFile, "\n");
    fflush(logFile);
}
