/**********************************************************************
   Copyright (C) Christopher Yeoh <cyeoh@samba.org> 2005
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**********************************************************************/

#include <stdio.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <stdlib.h>

#include "Game.H"
#include "protocol.h"

int createServer(void)
{
    int fd;
    struct sockaddr_in sa;
    int val = 1;

    memset(&sa, 0, sizeof(struct sockaddr_in)); 
    sa.sin_family = AF_INET;
    sa.sin_port = htons(DEFAULT_SPELLCAST_SERVER_PORT);
    sa.sin_addr.s_addr = INADDR_ANY;
    
    fd = socket(AF_INET, SOCK_STREAM, 0);
    if (fd<0) {
	perror("Could not create server socket");
	exit(1);
    }

    if (setsockopt(fd, SOL_SOCKET, SO_REUSEADDR, &val, sizeof(val))) {
	perror("setsockopt failed\n");
	exit(1);
    }

    if (bind(fd, (struct sockaddr *)&sa, sizeof(struct sockaddr_in)) < 0) { 
	perror("Could not bind to address for server\n");
	exit(1);
    } 

    listen(fd, 4);
    return(fd);
}

void gameLoop(int serverFD)
{
    int numPlayers;

    Game game(serverFD);

    // Allow people to connect
    numPlayers = game.PlayersJoining();
    if (numPlayers<2) {
	printf("Only have %i players. Exiting\n", numPlayers);
	exit(1);
    }

    // Play game
    game.StartGame();
}


int main(int argc, char *argv[])
{
    int serverFD;
    serverFD = createServer();

    gameLoop(serverFD);
}
