#ifndef _PLAYER_H
#define _PLAYER_H

/**********************************************************************
   Copyright (C) Christopher Yeoh <cyeoh@samba.org> 2005
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**********************************************************************/
#include "Wizard.H"
#include "RemoteConnection.H"

class Player : public Wizard {
public:

    struct SpellCast {
	Player *source;
	BaseCreature *target;
	Spell spellCast;
	bool spellWorked;
	string resultMessage;

    };

    class SpellCastPredicateSpellEqual {
    public:
	SpellCastPredicateSpellEqual(Spell SpellToMatch) {
	    spellsToMatch.push_back(SpellToMatch);
	}

	SpellCastPredicateSpellEqual(const vector<Spell> &SpellsToMatch)
	    : spellsToMatch(SpellsToMatch) {}
    
	bool operator()(SpellCast SpellCastInstance) {
	    if (find(spellsToMatch.begin(),
		     spellsToMatch.end(), SpellCastInstance.spellCast)
		!= spellsToMatch.end()) {
		matches.push_back(SpellCastInstance);
		return true;
	    } else {
		return false;
	    }
	}

	const vector<SpellCast> &getMatches() const {
	    return matches;
	}

    private:
	vector<Spell> spellsToMatch;
	vector<SpellCast> matches;
    };
    
    class SpellCastOrderCompare {
    public:
	bool operator()(const SpellCast &First, const SpellCast &Second) const{
	    return First.spellCast < Second.spellCast;
	}
    };
    

    Player(int FD);

    void sendNewPlayerInfo(Player *NewPlayer);
    void sendNewMonsterInfo(NonWizard *Monster);
    void askForGestures();

    void sendGesturesSeen(Player *OfPlayer);
    void sendGesturesSeenEnd();
    
    void askForSpellSelection(const vector<Spell> &LeftHandSpells,
			      const vector<Spell> &RightHandSpells);

    void getSpellsSevoidlected(Spell *LeftHandSpell, Spell *RightHandSpell);
    // might not need this one?

    // Ask player who to direct spells at
    void askForSpellDirections(const vector<int> &ValidTargetIDs);

    // Ask player who to direct monsters at
    void askForMonsterDirections(const vector<int> &ValidTargetIDs);

    void getSpellsCast(Spell *LeftHandSpell, int *LeftTargetID,
		       Spell *RightHandSpell, int *RightTargetID);


    // Get where monsters were directed by player
    const map<NonWizard *, int> &getMonsterDirections() const;

    // Tell players what spells have been cast
    void sendSpellCast(const SpellCast &SpellInfo);
    void sendSpellCastEnd(); // Sent all information about spells cast

    // Tell players result of monster attacks
    void sendMonsterAttack(int SourceID, int TargetID, int Damage,
			    const string &ResultMessage);
    void sendMonsterAttackEnd();

    // Tell players of the state of all other creatures
    void sendCreatureState(BaseCreature *Creature);
    void sendCreatureStateEnd();

    // Tell players that game has ended
    void sendEndGame(Player *Winner);

    // So we can work out when game can proceed
    bool amWaitingForResponse() const;
    void clearWaitForResponse();

    const RemoteConnection &connection() const;
    RemoteConnection &connection();

    // Process incoming message
    void ProcessMessage();

private:

    RemoteConnection remoteConnection;
    bool waitingForResponse;
    Spell leftHandSpell, rightHandSpell;
    int leftHandSpellTargetID, rightHandSpellTargetID;
    vector<Spell> validLHSpells;
    vector<Spell> validRHSpells;
    vector<int> validTargetIDs;
    map<NonWizard *, int> monsterTargets;
};


#endif

