#ifndef _NONWIZARD_H
#define _NONWIZARD_H

/**********************************************************************
   Copyright (C) Christopher Yeoh <cyeoh@samba.org> 2005
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**********************************************************************/

#include <string>

#include "BaseCreature.H"
#include "Wizard.H"

using namespace std;

class NonWizard : public BaseCreature {
public:
    NonWizard(int MonsterType, int DamageInflicted, int NumHitPoints, 
	      Wizard *Owner);
    
    bool applyRemoveEnchantmentSpell(string *Message);
    bool applyDispelMagicSpell(string *Message);
    bool applyAmnesiaSpell(string *Message);
    bool applyConfusionSpell(string *Message);
    bool applyCharmPersonSpell(string *Message);
    bool applyCharmMonsterSpell(string *Message);
    bool applyParalysisSpell(string *Message);
    bool applyFearSpell(string *Message);
    bool applyAntiSpell(string *Message);
    bool applyBlindnessSpell(string *Message);
    bool applyInvisibilitySpell(string *Message);
    bool applyDelayedEffectSpell(string *Message);
    bool applyPermanencySpell(string *Message);

    // Get creature type
    int getMonsterType() const;

    Wizard *getOwner() const;

private:
    const int monsterType;
    Wizard *owner;
};

#endif
