#/**********************************************************************
#   Copyright (C) Christopher Yeoh <cyeoh@samba.org> 2005
#   
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#   
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#   
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#**********************************************************************/

#map< Spell, deque<Spells::GesturePair> > Spells::spellToGestureMap;
#vector<Spell> Spells::spellsNullifiedByDispelMagic;
#vector<Spell> Spells::spellsNullifiedByCounterSpell;
#vector<Spell> Spells::spellsEnchantmentCancelled;

# bool Spells::classInitialised = false;

nspells = dict(enumerate([
    'NONE', 'SHIELD', 'COUNTER_SPELL', 'COUNTER_SPELL1', 'MAGIC_MIRROR', 'DISPEL_MAGIC', 'RAISE_DEAD', 'MISSILE', 'FINGER_OF_DEATH', 'LIGHTNING_BOLT', 'LIGHTNING_BOLT1', 'CAUSE_LIGHT_WOUNDS', 'CAUSE_HEAVY_WOUNDS', 'FIREBALL', 'FIRESTORM', 'ICESTORM', 'AMNESIA', 'CONFUSION', 'CHARM_PERSON', 'CHARM_MONSTER', 'PARALYSIS', 'FEAR', 'ANTI_SPELL', 'PROTECTION_FROM_EVIL', 'RESIST_HEAT', 'RESIST_COLD', 'DISEASE', 'POISON', 'BLINDNESS', 'INVISIBILITY', 'HASTE', 'TIME_STOP', 'DELAYED_EFFECT', 'PERMANENCY', 'REMOVE_ENCHANTMENT', 'CURE_LIGHT_WOUNDS', 'CURE_HEAVY_WOUNDS', 'SUMMON_GOBLIN', 'SUMMON_OGRE', 'SUMMON_TROLL', 'SUMMON_GIANT', 'SUMMON_FIRE_ELEMENTAL', 'SUMMON_ICE_ELEMENTAL', 'SURRENDER', 'STAB', 'FINAL_MARKER', ]))

rspells = dict([(x,y) for y,x in enumerate([
    'NONE', 'SHIELD', 'COUNTER_SPELL', 'COUNTER_SPELL1', 'MAGIC_MIRROR', 'DISPEL_MAGIC', 'RAISE_DEAD', 'MISSILE', 'FINGER_OF_DEATH', 'LIGHTNING_BOLT', 'LIGHTNING_BOLT1', 'CAUSE_LIGHT_WOUNDS', 'CAUSE_HEAVY_WOUNDS', 'FIREBALL', 'FIRESTORM', 'ICESTORM', 'AMNESIA', 'CONFUSION', 'CHARM_PERSON', 'CHARM_MONSTER', 'PARALYSIS', 'FEAR', 'ANTI_SPELL', 'PROTECTION_FROM_EVIL', 'RESIST_HEAT', 'RESIST_COLD', 'DISEASE', 'POISON', 'BLINDNESS', 'INVISIBILITY', 'HASTE', 'TIME_STOP', 'DELAYED_EFFECT', 'PERMANENCY', 'REMOVE_ENCHANTMENT', 'CURE_LIGHT_WOUNDS', 'CURE_HEAVY_WOUNDS', 'SUMMON_GOBLIN', 'SUMMON_OGRE', 'SUMMON_TROLL', 'SUMMON_GIANT', 'SUMMON_FIRE_ELEMENTAL', 'SUMMON_ICE_ELEMENTAL', 'SURRENDER', 'STAB', 'FINAL_MARKER', ])])

spells = {
'SHIELD': [ ( 'palm', 'nothing' ), ],
'REMOVE_ENCHANTMENT': [ ('palm', None), ('point', None), ('wave', None), ('palm', None), ],
'MAGIC_MIRROR': [ ('clap', 'clap'), ('wave', 'wave'), ],
'COUNTER_SPELL': [ ('wave', None), ('palm', None), ('palm', None), ],
'COUNTER_SPELL1': [ ('wave', None), ('wave', None), ('snap', None), ],
'DISPEL MAGIC': [ ('clap', 'clap'), ('point', None), ('palm', None), ('wave', None) ],
'RAISE DEAD': [ ('point', None), ('wave', None), ('wave', None), ('finger', None), ('wave', None), ('clap', 'clap'), ],
'CURE_LIGHT_WOUNDS': [ ('point', None), ('finger', None), ('wave', None), ],
'CURE_HEAVY_WOUNDS': [ ('point', None), ('finger', None), ('palm', None), ('wave', None), ],
'SUMMON GOBLIN': [ ('snap', None), ('finger', None), ('wave', None), ],
'STAB':[ ('knife', None) ],
'SUMMON_OGRE':[ ('palm', None), ('snap',None), ('finger', None), ('wave', None), ],
'SUMMON_TROLL':[ ('finger',None), ('palm',None), ('snap',None), ('finger',None), ('wave',None), ],
'FIRESTORM':[ ('snap',None), ('wave',None), ('wave',None), ('clap','clap'), ],
'FIREBALL':[ ('finger',None), ('snap',None), ('snap',None), ('point',None), ('point',None), ],
'RESIST_HEAT':[ ('wave',None), ('wave',None), ('finger',None), ('palm',None), ],
'RESIST_COLD':[ ('snap',None), ('snap',None), ('finger',None), ('palm',None), ],
'MISSILE':[ ('snap', None), ('point', None), ],
'FINGER_OF_DEATH':[ ('palm', None), ('wave', None), ('palm', None), ('finger', None), ('snap', None), ('snap', None), ('snap', None), ('point', None), ],
'FINGER_OF_DEATH1':[ ('palm', None), ('wave', None), ('palm', None), ('finger', None), ('snap', None), ('snap', None), ('snap', None), ('point', None), ],
'LIGHTNING_BOLT':[ ('point', None), ('finger', None), ('finger', None), ('point', None), ('point', None), ],
'LIGHTNING_BOLT1':[ ('wave', None), ('point', None), ('point', None), ('clap','clap'), ],
'ICESTORM':[ ('wave', None), ('snap', None), ('snap', None), ('clap','clap'), ],
'SUMMON_GIANT':[ ('wave', None), ('finger', None), ('palm', None), ('snap',None), ('finger',None), ('wave',None), ],
}



#    gestureList.clear();
#    gestureList.push_back(GesturePair(GST_WAVE, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_FINGER, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_PALM, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_SNAP, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_FINGER, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_WAVE, GST_NOTHING));
#    spellToGestureMap[SPL_SUMMON_GIANT] = gestureList;
#
#    gestureList.clear();
#    gestureList.push_back(GesturePair(GST_CLAP, GST_CLAP));
#    gestureList.push_back(GesturePair(GST_SNAP, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_WAVE, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_WAVE, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_SNAP, GST_NOTHING));
#    spellToGestureMap[SPL_SUMMON_FIRE_ELEMENTAL] = gestureList;
#    spellToGestureMap[SPL_SUMMON_ICE_ELEMENTAL] = gestureList;
#    // fire and ice elemental spells have been separated
#
#    gestureList.clear();
#    gestureList.push_back(GesturePair(GST_WAVE, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_FINGER, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_PALM, GST_NOTHING));
#    spellToGestureMap[SPL_CAUSE_LIGHT_WOUNDS] = gestureList;
#
#    gestureList.clear();
#    gestureList.push_back(GesturePair(GST_WAVE, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_PALM, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_FINGER, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_POINT, GST_NOTHING));
#    spellToGestureMap[SPL_CAUSE_HEAVY_WOUNDS] = gestureList;
#
#
#    gestureList.clear();
#    gestureList.push_back(GesturePair(GST_POINT, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_PALM, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_PALM, GST_NOTHING));
#    spellToGestureMap[SPL_AMNESIA] = gestureList;
#
#    gestureList.clear();
#    gestureList.push_back(GesturePair(GST_POINT, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_SNAP, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_FINGER, GST_NOTHING));
#    spellToGestureMap[SPL_CONFUSION] = gestureList;
#
#    gestureList.clear();
#    gestureList.push_back(GesturePair(GST_PALM, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_SNAP, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_POINT, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_FINGER, GST_NOTHING));
#    spellToGestureMap[SPL_CHARM_PERSON] = gestureList;
#
#    gestureList.clear();
#    gestureList.push_back(GesturePair(GST_PALM, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_SNAP, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_POINT, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_POINT, GST_NOTHING));
#    spellToGestureMap[SPL_CHARM_MONSTER] = gestureList;
#
#    gestureList.clear();
#    gestureList.push_back(GesturePair(GST_FINGER, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_FINGER, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_FINGER, GST_NOTHING));
#    spellToGestureMap[SPL_PARALYSIS] = gestureList;
#
#    gestureList.clear();
#    gestureList.push_back(GesturePair(GST_SNAP, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_WAVE, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_POINT, GST_NOTHING));
#    spellToGestureMap[SPL_FEAR] = gestureList;
#
#    gestureList.clear();
#    gestureList.push_back(GesturePair(GST_SNAP, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_PALM, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_FINGER, GST_NOTHING));
#    spellToGestureMap[SPL_ANTI_SPELL] = gestureList;
#
#    gestureList.clear();
#    gestureList.push_back(GesturePair(GST_WAVE, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_WAVE, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_PALM, GST_NOTHING));
#    spellToGestureMap[SPL_PROTECTION_FROM_EVIL] = gestureList;
#
#    gestureList.clear();
#    gestureList.push_back(GesturePair(GST_POINT, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_SNAP, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_FINGER, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_FINGER, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_FINGER, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_CLAP, GST_CLAP));
#    spellToGestureMap[SPL_DISEASE] = gestureList;
#
#    gestureList.clear();
#    gestureList.push_back(GesturePair(GST_POINT, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_WAVE, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_WAVE, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_FINGER, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_WAVE, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_POINT, GST_NOTHING));
#    spellToGestureMap[SPL_POISON] = gestureList;
#    
#    gestureList.clear();
#    gestureList.push_back(GesturePair(GST_POINT, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_WAVE, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_FINGER, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_FINGER, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_POINT, GST_POINT));
#    spellToGestureMap[SPL_BLINDNESS] = gestureList;
#    
#    gestureList.clear();
#    gestureList.push_back(GesturePair(GST_PALM, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_PALM, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_WAVE, GST_WAVE));
#    gestureList.push_back(GesturePair(GST_SNAP, GST_SNAP));
#    spellToGestureMap[SPL_INVISIBILITY] = gestureList;
#
#    gestureList.clear();
#    gestureList.push_back(GesturePair(GST_PALM, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_WAVE, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_PALM, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_WAVE, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_WAVE, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_CLAP, GST_CLAP));
#    spellToGestureMap[SPL_HASTE] = gestureList;
#
#    gestureList.clear();
#    gestureList.push_back(GesturePair(GST_SNAP, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_PALM, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_PALM, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_CLAP, GST_CLAP));
#    spellToGestureMap[SPL_TIME_STOP] = gestureList;
#
#    gestureList.clear();
#    gestureList.push_back(GesturePair(GST_POINT, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_WAVE, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_SNAP, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_SNAP, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_SNAP, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_PALM, GST_NOTHING));
#    spellToGestureMap[SPL_DELAYED_EFFECT] = gestureList;
#
#    gestureList.clear();
#    gestureList.push_back(GesturePair(GST_SNAP, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_PALM, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_FINGER, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_PALM, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_SNAP, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_POINT, GST_NOTHING));
#    gestureList.push_back(GesturePair(GST_WAVE, GST_NOTHING));
#    spellToGestureMap[SPL_PERMANENCY] = gestureList;
#
#    gestureList.clear();
#    gestureList.push_back(GesturePair(GST_PALM, GST_PALM));
#    spellToGestureMap[SPL_SURRENDER] = gestureList;
#

counterspell = [ 'shield', 'remove enchantment', 'magic mirror', 'raise dead', 'cure light wounds', 'cure heavy wounds', 'summon goblin', 'summon ogre', 'summon troll', 'summon giant', 'summon fire elemental', 'summon ice elemental', 'missile', 'lightning bolt', 'lightning bolt1', 'cause light wounds', 'cause heavy wounds', 'fireball', 'firestorm', 'icestorm', 'amnesia', 'confusion', 'charm person', 'charm monster', 'paralysis', 'fear', 'anti spell', 'protection from evil', 'resist heat', 'resist cold', 'disease', 'poison', 'blindness', 'invisibility', 'haste', 'time stop', 'delayed effect', 'permanency', ]

dispel = [ 'counter spell', 'counter spell 1', 'finger of death', ]

enchantments = [ 'amnesia', 'confusion', 'charm person', 'charm monster',
                'paralysis', 'fear', ]

def getSpellsForGestures(gestures):
	left, right = [], []
	for name, spell in spells.items():
		if len(spell) < len(gestures):
			continue
		seq = zip(spell, gestures)

		for ((s1, s2), (g1, g2)) in seq:
			if s1 and s1 != g1:
				break 
			if s2 and s2 != g2:
				break
		else:
			left.append(name)

		if not name in ('MAGIC_MIRROR', 'SURRENDER'):
			for ((s2, s1), (g1, g2)) in seq:
				if s1 and s1 != g1:
					break 
				if s2 and s2 != g2:
					break
			else:
				right.append(name)

	if not left:
		left = ['NONE']
	if not right:
		right = ['NONE']

	return [rspells.get(x, 0) for x in left],\
			[rspells.get(x, 0) for x in right]
			
creatures = [
'goblin', 'orge', 'troll', 'giant', 'fire elemental', 'ice elemental'
]

def paralysis(oldgesture):
	if oldgesture == 'clap':
		return 'finger'
	if oldgesture == 'snap':
		return 'point'
	if oldgesture == 'wave':
		return 'palm'
	return oldgesture

def reflectable(spell):
	return not spell in ('magic mirror', 'stab', 'surrender')

def any(seq):
	for x in seq:
		if x:
			return True
	return False

def twohands(spell):
	return any([x[1] for x in spells])

