#ifndef __THOTHEXCEPTION_H__
#define __THOTHEXCEPTION_H__
/*
 * Copyright (C) Michael Fagan <Michael.Fagan@protocom.com.au> 2005
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <exception>
#include <string>

namespace thoth
{
using std::string;    


class ThothException : public std::exception
{
public:
        ThothException(const string& whatp) : m_what(whatp)
    { }

        ~ThothException() throw()
    { }
    
    virtual const char* what() const throw();

private:
    string  m_what;
    
}; // class ThothException

    
}; // namespace thoth

#endif /*__THOTHEXCEPTION_H__*/
