
#include "SpellAgents.h"
#include <ctype.h>

namespace thoth
{


void SpellCastAgent::init()
{
    addSignal("white-gesture");
    addSignal("spell-enable");
    addSignal("want-spell");

    m_want_left = getSignal("want-left-gesture");
    m_want_right = getSignal("want-right-gesture");
    m_l_can_cast = getSignal("left-can-cast-spell");
    m_r_can_cast = getSignal("right-can-cast-spell");
} // init()


void SpellCastAgent::reset()
{
    m_state_left = m_state_right = (char*)m_gestures.c_str();
    m_enable = 1;
    m_l_count = m_r_count = 0;
} // reset()


void SpellCastAgent::signal(Signal& the_signal, int param1, int param2)
{
    if ( the_signal.getName() == "white-gesture" )
    {
            // left check
        if ( matchGesture(m_state_left[0], param1, param2) )
        {
            ++m_state_left;
            if ( m_enable != 0 )
            {
                if ( m_state_left[0] == 0 )
                {
                    m_l_can_cast->signal(m_spell);
                    m_state_left = (char*)m_gestures.c_str();
                    m_l_count = 0;
                    if (m_once)
                    {
                        getSignal("spell-enable")->signal(m_spell, 0);
                    }
                } else {
                    m_want_left->signal(char2gesture(m_state_left[0]), m_strength + m_l_count);
                    if ( islower(m_state_left[0]) )
                    {
                        m_want_right->signal(char2gesture(m_state_left[0]), m_strength + m_l_count);
                    }
                    ++m_l_count;
                }
            }
        } else {
                // out of sequence gesture so reset
            m_state_left = (char*)m_gestures.c_str();
            m_l_count = 0;
        }

            // right check
        if ( matchGesture(m_state_right[0], param2, param1) )
        {
            ++m_state_right;
            if ( m_enable != 0 )
            {
                if ( m_state_right[0] == 0 )
                {
                    m_r_can_cast->signal(m_spell);
                    m_state_right = (char*)m_gestures.c_str();
                    m_r_count = 0;
                    if (m_once)
                    {
                        getSignal("spell-enable")->signal(m_spell, 0);
                    }
                } else {
                    m_want_right->signal(char2gesture(m_state_right[0]), m_strength + m_r_count);
                    if ( islower(m_state_right[0]) )
                    {
                        m_want_left->signal(char2gesture(m_state_right[0]), m_strength + m_r_count);
                    }
                    ++m_r_count;
                }
            }
        } else {
                // out of sequence gesture so reset
            m_state_right = (char*)m_gestures.c_str();
            m_r_count = 0;
        }
        
    } else if ( the_signal.getName() == "spell-enable" )
    {
        if ( param1 == m_spell )
        {
            m_enable = param2;
        }
    } else if ( ( the_signal.getName() == "want-spell" ) && ( param1 == m_spell) )
    {
        m_want_left->signal(char2gesture(m_state_left[0]), m_l_count + param2);
        if ( islower(m_state_left[0]) )
        {
            m_want_right->signal(char2gesture(m_state_left[0]), m_l_count + param2);
        }
        m_want_right->signal(char2gesture(m_state_right[0]), m_r_count + param2);
        if ( islower(m_state_right[0]) )
        {
            m_want_left->signal(char2gesture(m_state_right[0]), m_r_count + param2);
        }
    }
} // signal()


bool SpellCastAgent::matchGesture(char ch, int pri, int sec)
{
    int g = char2gesture(ch);
    if ( !islower(ch) )
    {
        return (g == pri);
    } else {
        return (g == pri) && (g == sec);
    }
} // matchGesture()



void GestureMux::init()
{
    addSignal("want-left-gesture");
    addSignal("want-right-gesture");

    m_send = getSignal("send-gestures");
} // init()


void GestureMux::reset()
{
    m_last_stab = false;
    for(int i = 0; i < 8; ++i)
    {
        for(int j = 0; j < 8; ++j)
        {
            m_state[i][j] = 0;
        }
    }
} // reset()


void GestureMux::signal(Signal& the_signal, int param1, int param2)
{
    if ( the_signal.getName() == "want-left-gesture" )
    {
        update(true, param1, param2);
    } else if ( the_signal.getName() == "want-right-gesture" )
    {
        update(false, param1, param2);
    }
} // signal()


void GestureMux::cycle()
{
    int left = GST_NOTHING;
    int right = GST_NOTHING;

    find(left, right);

    m_send->signal(left, right);
} // cycle()


void GestureMux::update(bool left, int gesture, int amt)
{
    if ( amt <= 0 ) amt = 1;
    if (left)
    {
        for(int i = 1; i < 8; ++i)
        {
            m_state[gesture][i] += amt;
        }
    } else {
        for(int i = 1; i < 8; ++i)
        {
            m_state[i][gesture] += amt;
        }
    }
} // update()


void GestureMux::find(int& left, int& right)
{
        // no surrender
    m_state[GST_PALM][GST_PALM] = 0;

        // clap is alwasy 2 handed
    for(int i = 1; i < 8; ++i)
    {
        if ( i != GST_CLAP )
        {
            m_state[i][GST_CLAP] = m_state[GST_CLAP][i] = 0;
        }
    }
        // not mr stabby
    if ( m_last_stab )
    {
        for(int i = 1; i < 8; ++i)
        {
            m_state[i][GST_KNIFE] = m_state[GST_KNIFE][i] = 0;
        }        
    }
    
    int max = 0;
    for(int i = 1; i < 8; ++i)
    {
        for(int j = 1; j < 8; ++j)
        {
            if ( m_state[i][j] > max )
            {
                left = i;
                right = j;
                max = m_state[i][j];
            }
            m_state[i][j] = 0;
        }
    }
    m_last_stab = (left == GST_KNIFE) || (right == GST_KNIFE);
} // find()


void RandomAgent::init()
{
    addSignal("white-gesture");

    m_want_left = getSignal("want-left-gesture");
    m_want_right = getSignal("want-right-gesture");
} // init()


void RandomAgent::reset()
{
} // reset()


void RandomAgent::signal(Signal& the_signal, int param1, int param2)
{
    if ( the_signal.getName() == "white-gesture" )
    {
        if ( ( param1 == GST_NOTHING ) || ( param1 == GST_ANTISPELL ) )
        {
            m_want_left->signal(random() % 8);
            m_want_left->signal(random() % 8);
            m_want_left->signal(random() % 8);
            m_want_left->signal(GST_WAVE, 2);
        }
        if ( ( param2 == GST_NOTHING ) || ( param2 == GST_ANTISPELL ) )
        {
            m_want_right->signal(random() % 8);
            m_want_right->signal(random() % 8);
            m_want_right->signal(random() % 8);
            m_want_right->signal(GST_POINT, 2);
        }
    }    
} // signal()



void SpellDetectAgent::init()
{
    addSignal("red-gesture");

    m_want_spell = getSignal("want-spell");
    m_l_is_cast = getSignal("red-is-cast-left-spell");
    m_r_is_cast = getSignal("red-is-cast-right-spell");
} // init()


void SpellDetectAgent::reset()
{
    m_state_left = m_state_right = (char*)m_gestures.c_str();
    m_l_count = m_r_count = 0;
} // reset()


void SpellDetectAgent::signal(Signal& the_signal, int param1, int param2)
{
    if ( the_signal.getName() == "red-gesture" )
    {
            // left check
        if ( matchGesture(m_state_left[0], param1, param2) )
        {
            ++m_state_left;
            if ( m_state_left[0] == 0 )
            {
                m_l_is_cast->signal(m_spell);
                m_state_left = (char*)m_gestures.c_str();
                m_l_count = 0;
            } else {
                if ( m_l_count > 0 )
                {
                    if ( m_l_count <= m_am_len )
                    {
                        m_want_spell->signal(SPL_ANTI_SPELL, m_strength + m_l_count);
                    }
                    if ( m_l_count == m_am_len )
                    {
                        m_want_spell->signal(SPL_COUNTER_SPELL, m_strength + m_l_count);
                    }
                    if ( ( m_count1 != SPL_NONE ) &&
                         ( m_l_count == m_len ) )
                    {
                        m_want_spell->signal(m_count1, m_strength + m_l_count);
                    }
                }
                ++m_l_count;
            }
        } else {
                // out of sequence gesture so reset
            m_state_left = (char*)m_gestures.c_str();
            m_l_count = 0;
        }

            // right check
        if ( matchGesture(m_state_right[0], param2, param1) )
        {
            ++m_state_right;
            if ( m_state_right[0] == 0 )
            {
                m_r_is_cast->signal(m_spell);
                m_state_right = (char*)m_gestures.c_str();
                m_r_count = 0;
            } else {
                if ( m_r_count > 0 )
                {
                    if ( m_r_count <= m_am_len )
                    {
                        m_want_spell->signal(SPL_ANTI_SPELL, m_strength + m_r_count);
                    }
                    if ( m_r_count == m_am_len )
                    {
                        m_want_spell->signal(SPL_COUNTER_SPELL, m_strength + m_r_count);
                    }
                    if ( ( m_count1 != SPL_NONE ) &&
                         ( m_r_count == m_len ) )
                    {
                        m_want_spell->signal(m_count1, m_strength + m_r_count);
                    }
                }
                ++m_r_count;
            }
        } else {
                // out of sequence gesture so reset
            m_state_right = (char*)m_gestures.c_str();
            m_r_count = 0;
        }
    }
} // signal()


bool SpellDetectAgent::matchGesture(char ch, int pri, int sec)
{
    int g = char2gesture(ch);
    if ( !islower(ch) )
    {
        return (g == pri);
    } else {
        return (g == pri) && (g == sec);
    }
} // matchGesture()


}; // namespace thoth
