
#include "BrainInit.h"
#include "SpellAgents.h"
#include "Signal.h"


using thoth::SpellCastAgent;
using thoth::SpellDetectAgent;
using thoth::GestureMux;
using thoth::RandomAgent;


void InitBrain(WizardBrain& brain)
{
        //
        // Layer 1 - spell casting agents
        //
    brain.addAgent( new SpellCastAgent(SPL_SHIELD, "P", false, -1) );
    brain.addAgent( new SpellCastAgent(SPL_COUNTER_SPELL, "WWS") );
    brain.addAgent( new SpellCastAgent(SPL_MAGIC_MIRROR, "cw") );
    brain.addAgent( new SpellCastAgent(SPL_DISPEL_MAGIC, "cDPW") );
    brain.addAgent( new SpellCastAgent(SPL_RAISE_DEAD, "DWWFWc") );
    brain.addAgent( new SpellCastAgent(SPL_MISSILE, "SD") );
    brain.addAgent( new SpellCastAgent(SPL_FINGER_OF_DEATH, "PWPFSSSD", true, 5) );
    brain.addAgent( new SpellCastAgent(SPL_LIGHTNING_BOLT1, "WDDc", true, 4) );
    brain.addAgent( new SpellCastAgent(SPL_LIGHTNING_BOLT, "DFFDD") );
    brain.addAgent( new SpellCastAgent(SPL_CAUSE_LIGHT_WOUNDS, "WFP") );
    brain.addAgent( new SpellCastAgent(SPL_CAUSE_HEAVY_WOUNDS, "WPFD") );
    brain.addAgent( new SpellCastAgent(SPL_FIREBALL, "FSSDD") );
    brain.addAgent( new SpellCastAgent(SPL_FIRESTORM, "SWWc") );
    brain.addAgent( new SpellCastAgent(SPL_ICESTORM, "WSSc") );
    brain.addAgent( new SpellCastAgent(SPL_AMNESIA, "DPP") );
    brain.addAgent( new SpellCastAgent(SPL_CONFUSION, "DSF", true, 1) );
    brain.addAgent( new SpellCastAgent(SPL_CHARM_PERSON, "PSDF") );
    brain.addAgent( new SpellCastAgent(SPL_CHARM_MONSTER, "PSDD") );
    brain.addAgent( new SpellCastAgent(SPL_PARALYSIS, "FFF", true) );
    brain.addAgent( new SpellCastAgent(SPL_FEAR, "SWD", true) );
    brain.addAgent( new SpellCastAgent(SPL_ANTI_SPELL, "SPF", 2) );
    brain.addAgent( new SpellCastAgent(SPL_PROTECTION_FROM_EVIL, "WWP", true) );
    brain.addAgent( new SpellCastAgent(SPL_RESIST_HEAT, "WWFP", true, -1) );
    brain.addAgent( new SpellCastAgent(SPL_RESIST_COLD, "SSFP", true, -1) );
    brain.addAgent( new SpellCastAgent(SPL_DISEASE, "DSFFFc", true, 1) );
    brain.addAgent( new SpellCastAgent(SPL_POISON, "DWWFWD", true, 4) );
    brain.addAgent( new SpellCastAgent(SPL_BLINDNESS, "DWFFd", true) );
    brain.addAgent( new SpellCastAgent(SPL_INVISIBILITY, "PPws", true) );
    brain.addAgent( new SpellCastAgent(SPL_REMOVE_ENCHANTMENT, "PDWP") );
    brain.addAgent( new SpellCastAgent(SPL_CURE_LIGHT_WOUNDS, "DFW") );
    brain.addAgent( new SpellCastAgent(SPL_CURE_HEAVY_WOUNDS, "DFPW") );
    brain.addAgent( new SpellCastAgent(SPL_SUMMON_GOBLIN, "SFW") );
    brain.addAgent( new SpellCastAgent(SPL_SUMMON_OGRE, "PSFW") );
    brain.addAgent( new SpellCastAgent(SPL_SUMMON_TROLL, "FPSFW", false) );
    brain.addAgent( new SpellCastAgent(SPL_SUMMON_GIANT, "WFPSFW") );
    brain.addAgent( new SpellCastAgent(SPL_SUMMON_FIRE_ELEMENTAL, "cSWWS") );
    brain.addAgent( new SpellCastAgent(SPL_SUMMON_ICE_ELEMENTAL, "cSWWS") );
    brain.addAgent( new SpellCastAgent(SPL_STAB, ">") );

        //
        // Layer 2 - spell detecting agents
        //
    brain.addAgent( new SpellDetectAgent(SPL_SHIELD, "P") );
    brain.addAgent( new SpellDetectAgent(SPL_COUNTER_SPELL, "WWS") );
    brain.addAgent( new SpellDetectAgent(SPL_MAGIC_MIRROR, "cw") );
    brain.addAgent( new SpellDetectAgent(SPL_DISPEL_MAGIC, "cDPW") );
    brain.addAgent( new SpellDetectAgent(SPL_RAISE_DEAD, "DWWFWc") );
    brain.addAgent( new SpellDetectAgent(SPL_MISSILE, "SD") );
    brain.addAgent( new SpellDetectAgent(SPL_FINGER_OF_DEATH, "PWPFSSSD", 10, SPL_RAISE_DEAD, 5) );
    brain.addAgent( new SpellDetectAgent(SPL_LIGHTNING_BOLT1, "WDDc") );
    brain.addAgent( new SpellDetectAgent(SPL_LIGHTNING_BOLT, "DFFDD") );
    brain.addAgent( new SpellDetectAgent(SPL_CAUSE_LIGHT_WOUNDS, "WFP") );
    brain.addAgent( new SpellDetectAgent(SPL_CAUSE_HEAVY_WOUNDS, "WPFD") );
    brain.addAgent( new SpellDetectAgent(SPL_FIREBALL, "FSSDD") );
    brain.addAgent( new SpellDetectAgent(SPL_FIRESTORM, "SWWc") );
    brain.addAgent( new SpellDetectAgent(SPL_ICESTORM, "WSSc") );
    brain.addAgent( new SpellDetectAgent(SPL_AMNESIA, "DPP") );
    brain.addAgent( new SpellDetectAgent(SPL_CONFUSION, "DSF", 2) );
    brain.addAgent( new SpellDetectAgent(SPL_CHARM_PERSON, "PSDF", 2) );
    brain.addAgent( new SpellDetectAgent(SPL_CHARM_MONSTER, "PSDD") );
    brain.addAgent( new SpellDetectAgent(SPL_PARALYSIS, "FFF") );
    brain.addAgent( new SpellDetectAgent(SPL_FEAR, "SWD") );
    brain.addAgent( new SpellDetectAgent(SPL_ANTI_SPELL, "SPF") );
    brain.addAgent( new SpellDetectAgent(SPL_PROTECTION_FROM_EVIL, "WWP") );
    brain.addAgent( new SpellDetectAgent(SPL_RESIST_HEAT, "WWFP") );
    brain.addAgent( new SpellDetectAgent(SPL_RESIST_COLD, "SSFP") );
    brain.addAgent( new SpellDetectAgent(SPL_DISEASE, "DSFFFc", 5, SPL_CURE_HEAVY_WOUNDS, 4) );
    brain.addAgent( new SpellDetectAgent(SPL_POISON, "DWWFWD", 8, SPL_DISPEL_MAGIC, 4) );
    brain.addAgent( new SpellDetectAgent(SPL_BLINDNESS, "DWFFd") );
    brain.addAgent( new SpellDetectAgent(SPL_INVISIBILITY, "PPws") );
    brain.addAgent( new SpellDetectAgent(SPL_REMOVE_ENCHANTMENT, "PDWP") );
    brain.addAgent( new SpellDetectAgent(SPL_CURE_LIGHT_WOUNDS, "DFW") );
    brain.addAgent( new SpellDetectAgent(SPL_CURE_HEAVY_WOUNDS, "DFPW") );
    brain.addAgent( new SpellDetectAgent(SPL_SUMMON_GOBLIN, "SFW") );
    brain.addAgent( new SpellDetectAgent(SPL_SUMMON_OGRE, "PSFW") );
    brain.addAgent( new SpellDetectAgent(SPL_SUMMON_TROLL, "FPSFW") );
    brain.addAgent( new SpellDetectAgent(SPL_SUMMON_GIANT, "WFPSFW") );
    brain.addAgent( new SpellDetectAgent(SPL_SUMMON_FIRE_ELEMENTAL, "cSWWS") );
    brain.addAgent( new SpellDetectAgent(SPL_SUMMON_ICE_ELEMENTAL, "cSWWS") );
    brain.addAgent( new SpellDetectAgent(SPL_STAB, ">") );

    
        //
        // Layer 3 - Higher processing
        //
    brain.addAgent( new GestureMux() );
    brain.addAgent( new RandomAgent() );

        // Agent to try cure'in disease/poison and other specialised behaviour

        
} // InitBrain()

