#include "common.h"


const char* gesture2str(Gesture g)
{
    switch(g)
    {
        case GST_NOTHING: return "-";
        case GST_KNIFE: return ">";
        case GST_FINGER: return "F";
        case GST_PALM: return "P";
        case GST_SNAP: return "S";
        case GST_WAVE: return "W";
        case GST_POINT: return "D";
        case GST_CLAP: return "c";
        case GST_ANTISPELL: return "*";

        case GST_FOG:
        default: return "?";
    }
} // gesture2str()


Gesture char2gesture(char ch)
{
    switch(ch)
    {
        case '-': return GST_NOTHING;
        case '>': return GST_KNIFE;
        case 'f':
        case 'F': return GST_FINGER;
        case 'p':
        case 'P': return GST_PALM;
        case 's':
        case 'S': return GST_SNAP;
        case 'w':
        case 'W': return GST_WAVE;
        case 'd':
        case 'D': return GST_POINT;
        case 'c': return GST_CLAP;
        case '*':
        default: return GST_ANTISPELL;
    }
} // char2gesture()


const char* monster2str(int t)
{
    switch(t)
    {
        case 0: return "Wizard";
        case SC_MONSTER_GOBLIN: return "Goblin";
        case SC_MONSTER_OGRE: return "Ogre";
        case SC_MONSTER_TROLL: return "Troll";
        case SC_MONSTER_GIANT: return "Giant";
        case SC_MONSTER_FIRE_ELEMENTAL: return "FireElemental";
        case SC_MONSTER_ICE_ELEMENTAL: return "IceElemental";
        default: return "imposter";
    }
} // monster2str()
