/* creature states as they come from the sc server */
enum SCCreatureStates {
  SC_CS_DEAD             = 1 << 0,
  SC_CS_SHIELD           = 1 << 1,
  SC_CS_AMNESIA          = 1 << 2,
  SC_CS_CONFUSION        = 1 << 4,
  SC_CS_CHARM_PERSON     = 1 << 6,
  SC_CS_PARALYSIS        = 1 << 8,
  SC_CS_FEAR             = 1 << 10,
  SC_CS_ANTI_SPELL       = 1 << 12,
  SC_CS_PROT_FROM_EVIL   = 1 << 13,
  SC_CS_RESIST_HEAT      = 1 << 15,
  SC_CS_RESIST_COLD      = 1 << 16,
  SC_CS_DISEASED         = 1 << 17,
  SC_CS_POISONED         = 1 << 18,
  SC_CS_BLINDED          = 1 << 19,
  SC_CS_INVISIBILITY     = 1 << 21,
};

/* internal creature states (unused bits not included so that
 * cs_score[] doesn't need as much space)
 */
enum CreatureStates {
  CS_DEAD                = 1 << 0,
  CS_SHIELD              = 1 << 1,
  CS_AMNESIA             = 1 << 2,
  CS_CONFUSION           = 1 << 3,
  CS_CHARM_PERSON        = 1 << 4,
  CS_PARALYSIS           = 1 << 5,
  CS_FEAR                = 1 << 6,
  CS_ANTI_SPELL          = 1 << 7,
  CS_PROT_FROM_EVIL      = 1 << 8,
  CS_RESIST_HEAT         = 1 << 9,
  CS_RESIST_COLD         = 1 << 10,
  CS_DISEASED            = 1 << 11,
  CS_POISONED            = 1 << 12,
  CS_BLINDED             = 1 << 13,
  CS_INVISIBILITY        = 1 << 14
};

#define NUM_CS_SCORE (1 << 15)
extern signed char cs_score[NUM_CS_SCORE];

typedef struct WizardState {
  /* gesture made so far */
  GestureList gl;

  /* enum CreatureStates */
  int state;

  /* damage_inflicted starts at 0, and when >= num_hit_points the
   * wizard is killed
   */
  int damage_inflicted;
  int num_hit_points;

  /* if protected from evil, diseased, poisoned, invisible, or blind,
   * how many turns left?
   */
  int prot_from_evil, disease, poison, invisible, blind;

  /* is one of this wizard's hands paralysed?
   * -1 for yes (we can pick which hand)
   * 0 for no
   * 1 for left
   * 2 for right
   */
  int paralysed;

  /* number of monsters (0), fire (1), and ice (2) elementals owned by
   * this wizard, their total remaining hit points, and total possible
   * hit points
   */
  int monster_num[3];
  int monster_hp[3];
  int monster_max_hp[3];
} WizardState;

#define WIZARD_MAX_NUM_HIT_POINTS 14

#define CS_ANY_ENCHANTMENT \
    (CS_AMNESIA | CS_CONFUSION | CS_CHARM_PERSON | CS_PARALYSIS | CS_FEAR)

#define CS_ONCE_OFF \
    (CS_SHIELD | CS_AMNESIA | CS_CONFUSION | CS_CHARM_PERSON | \
     CS_PARALYSIS | CS_FEAR | CS_ANTI_SPELL)

#define CS_REMOVE_ENCHANTMENTS \
    (CS_AMNESIA | \
     CS_CONFUSION | \
     CS_CHARM_PERSON | \
     CS_PARALYSIS | \
     CS_FEAR | \
     CS_ANTI_SPELL | \
     CS_PROT_FROM_EVIL | \
     CS_RESIST_HEAT | CS_RESIST_COLD | \
     CS_DISEASED | \
     CS_POISONED | \
     CS_BLINDED | \
     CS_INVISIBILITY)

void show_ws(WizardState *cs);
void init_wizard(void);
