#include <stdio.h>

#include "gestures.h"
#include "wizard.h"

signed char cs_score[NUM_CS_SCORE];

void show_ws(WizardState *ws) {
  printf("Wizard State:\n");
  print_gesture_list(ws->gl);
  printf("\n");
  printf("state %d\n", ws->state);
  printf("damage_inflicted %d\n", ws->damage_inflicted);
  printf("num_hit_points %d\n", ws->num_hit_points);
  if (ws->prot_from_evil) {
    printf("prot_from_evil %d\n", ws->prot_from_evil);
  }
  if (ws->paralysed) {
    printf("paralysed %d\n", ws->paralysed);
  }
  if (ws->disease) {
    printf("disease %d\n", ws->disease);
  }
  if (ws->poison) {
    printf("poison %d\n", ws->poison);
  }
  if (ws->invisible) {
    printf("invisible %d\n", ws->invisible);
  }
  if (ws->blind) {
    printf("blind %d\n", ws->blind);
  }
  printf("monster_num %d %d %d\n",
         ws->monster_num[0], ws->monster_num[1], ws->monster_num[2]);
  printf("monster_hp %d %d %d\n",
         ws->monster_hp[0], ws->monster_hp[1], ws->monster_hp[2]);
  printf("monster_max_hp %d %d %d\n",
         ws->monster_max_hp[0], ws->monster_max_hp[1], ws->monster_max_hp[2]);
}

void init_wizard(void) {
  int i;

  for (i = 0; i < NUM_CS_SCORE; i++) {
    /* this doesn't actually get used -- find_move() checks for
     * CS_DEAD separately
     */
    if (i & CS_DEAD) {
      cs_score[i] = -128;
      continue;
    }

    cs_score[i] = 0;

    if (i & CS_AMNESIA) {
      cs_score[i] += -2;
    }
    if (i & CS_CONFUSION) {
      cs_score[i] += -1;
    }
//  if (i & CS_CHARM_PERSON) {
//    cs_score[i] += -5;
//  }
//  if (i & CS_PARALYSIS) {
//    cs_score[i] += -1;
//  }
    if (i & CS_FEAR) {
      cs_score[i] += -2;
    }
    if (i & CS_PROT_FROM_EVIL) {
      cs_score[i] += 5;
    }
    if (i & CS_RESIST_HEAT) {
      cs_score[i] += 5;
    }
    if (i & CS_RESIST_COLD) {
      cs_score[i] += 5;
    }
    if (i & CS_DISEASED) {
      cs_score[i] += -20;
    }
    if (i & CS_POISONED) {
      cs_score[i] += -20;
    }
    if (i & CS_BLINDED) {
      cs_score[i] += -10;
    }
    if (i & CS_INVISIBILITY) {
      cs_score[i] += 10;
    }
  }
}
