#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>

#include "gestures.h"
#include "spells.h"
#include "wizard.h"
#include "moves.h"
#include "message.h"

char parse_gesture_char(char g) {
  switch (g) {
    case 'n': return GST_NOTHING;
    case 'k': return GST_KNIFE;
    case 'F': return GST_FINGER;
    case 'P': return GST_PALM;
    case 'S': return GST_SNAP;
    case 'W': return GST_WAVE;
    case 'p': return GST_POINT;
    case 'D': return GST_POINT;
    case 'c': return GST_CLAP;
    case 'a': return GST_ANTISPELL;
    case 'f': return GST_FOG;
    default:  return GST_NOTHING;
  }
}

/* convert a string like 'cc WW' into a GestureList */
GestureList parse_gl(char *s) {
  GestureList gl = 0;

  while (s[0] && s[1]) {
    s[0] = parse_gesture_char(s[0]);
    s[1] = parse_gesture_char(s[1]);
    gl = gl_push(gl, make_gp(s[0], s[1]));
    s += 2;
    if (!*s || *s != ' ') {
      break;
    }
    s++;
  }

  return gl;
}

extern int count_hit, count_miss;

int main(int argc, char *argv[]) {
  init_gestures();
  init_spells();
  init_moves();
  init_wizard();

  struct timeval t;

  WizardState *wizards;
  int num_wizards;
  int i;
  char s[100];
  Move best_move;

  printf("Num of wizards: ");
  fgets(s, 100, stdin);
  s[100] = '\0';
  num_wizards = atoi(s);

  wizards = calloc(num_wizards, sizeof(WizardState));

  while (1) {
    for (i = 0; i < num_wizards; i++) {
      wizards[i].num_hit_points = WIZARD_MAX_NUM_HIT_POINTS;

      printf("Wizard %d:\n", i);
      printf("Enter gesture list: ");
      fgets(s, 100, stdin);
      s[100] = '\0';
      wizards[i].gl = parse_gl(s);
      print_gesture_list(wizards[i].gl);
      printf("(%lld)\n", wizards[i].gl);

#if 0
      printf("Enter state: ");
      fgets(s, 100, stdin);
      s[100] = '\0';
      wizards[i].state = atoi(s);

      printf("Enter damage inflicted: ");
      fgets(s, 100, stdin);
      s[100] = '\0';
      wizards[i].damage_inflicted = atoi(s);

      printf("Enter paralysed: ");
      fgets(s, 100, stdin);
      s[100] = '\0';
      wizards[i].paralysed = atoi(s);

      printf("Enter blind: ");
      fgets(s, 100, stdin);
      s[100] = '\0';
      wizards[i].blind = atoi(s);

      printf("Enter monster_num[0]: ");
      fgets(s, 100, stdin);
      s[100] = '\0';
      wizards[i].monster_num[0] = atoi(s);

      printf("Enter monster_hp[0]: ");
      fgets(s, 100, stdin);
      s[100] = '\0';
      wizards[i].monster_hp[0] = atoi(s);

      printf("Enter monster_max_hp[0]: ");
      fgets(s, 100, stdin);
      s[100] = '\0';
      wizards[i].monster_max_hp[0] = atoi(s);
#endif
    }

//  printf("Enter lookahead: ");
//  fgets(s, 100, stdin);
//  s[100] = '\0';

    printf("Enter timeout: ");
    fgets(s, 100, stdin);
    s[100] = '\0';

    count_hit = 0;
    count_miss = 0;
    gettimeofday(&t, NULL);
    printf("%d.%06d\n", t.tv_sec, t.tv_usec);
    find_move_id(wizards, num_wizards, atoi(s), &best_move);
    gettimeofday(&t, NULL);
    printf("%d.%06d %d %d\n", t.tv_sec, t.tv_usec, count_hit, count_miss);

    break;
  }

  free(wizards);

  exit(0);
}
