#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <assert.h>

#include "protocol.h"

#include "message.h"

const int header_value = 0xDEADBEEF;
const int footer_value = 0xABCDFEDA;

int connect_to_server(char *host) {
  struct sockaddr_in sa;
  struct hostent *server;

  printf("Connecting to %s\n", host);

  server = gethostbyname(host);
  assert(server);

  int fd = socket(AF_INET, SOCK_STREAM, 0);
  if (fd < 0) {
    perror("socket");
    exit(1);
  }

  memset(&sa, 0, sizeof(struct sockaddr_in));
  sa.sin_family = AF_INET;
  sa.sin_port = htons(DEFAULT_SPELLCAST_SERVER_PORT);
  memcpy(&sa.sin_addr.s_addr, server->h_addr_list[0], server->h_length);

  if (connect(fd, (struct sockaddr *)&sa, sizeof(sa)) < 0) {
    perror("connect");
    exit(1);
  }

  return fd;
}

int read_bytes(int fd, void *data, int data_len) {
  int res, count = 0;

  while (count < data_len) {
    res = read(fd, data + count, data_len - count);
    if (res < 0) {
      perror("read");
      exit(1);
    } else if (res == 0) {
      printf("read_bytes(): EOF\n");
      exit(1);
    } else {
      count += res;
    }
  }

  return count;
}

void write_bytes(int fd, const void *data, int data_len)
{
  int res, index = 0;

  while (index < data_len) {
    res = write(fd, data + index, data_len - index);
    if (res < 0) {
      perror("write");
      exit(1);
    } else {
      index += res;
    }
  }
}

Message *msg_recv(int fd) {
  Message *msg = malloc(sizeof(Message));

  read_bytes(fd, msg, sizeof(Message));
  msg->header = ntohl(msg->header);
  msg->length = ntohl(msg->length);
  msg->cmd = ntohl(msg->cmd);

  assert(msg->header == header_value);
  assert(msg->length < 8192);

  msg = realloc(msg, msg->length);
  read_bytes(fd, msg->data, msg->length - sizeof(Message));

  int *footer = (int *)(msg->data + msg->length -
                        sizeof(Message) - sizeof(footer_value));
  *footer = ntohl(*footer);

  assert(*footer == footer_value);

  return msg;
}

void msg_send(int fd, int cmd, void *data, int data_len) {
  Message *msg = malloc(sizeof(Message) + data_len + sizeof(footer_value));

  msg->header = htonl(header_value);
  msg->length = htonl(sizeof(Message) + data_len + sizeof(footer_value));
  msg->cmd = htonl(cmd);
  memcpy(msg->data, data, data_len);
  memcpy(msg->data + data_len, &footer_value, sizeof(footer_value));

  int *footer = (int *)(msg->data + data_len);
  *footer = ntohl(*footer);

  write_bytes(fd, msg, sizeof(Message) + data_len + sizeof(footer_value));
  free(msg);
}
