#include <stdio.h>
#include <stdlib.h>
#include "gestures.h"

char gesture_print[16] = {
  'n', 'k', 'F', 'P', 'S', 'W', 'D', 'c',
  'a', 'f', 'x', 'x', 'x', 'x', 'x', 'x'
};

unsigned char poss_gp[MAX_POSS_GP + 1];
unsigned char poss_gp_noswap[MAX_POSS_GP_NOSWAP + 1];
unsigned char poss_gp_para[MAX_POSS_GP_PARA + 1];
unsigned char poss_gp_confused[MAX_POSS_GP_CONFUSED + 1];

void print_gesture_list(GestureList gl) {
  int i;

  for (i = 0; i < 8; i++) {
    unsigned char g = gl >> (8 * (7 - i));
    printf("%c%c ", gesture_print[(g >> 4) & 0x0F],
                    gesture_print[g & 0x0F]);
  }
}

static void init_poss_gp(void) {
  /* i: poss_gp index
   * j: poss_gp_noswap index
   * k: poss_gp_para index
   * l: poss_gp_confused index
   */
  int i = 0, j = 0, k = 0, l = 0;
  int left, right;

  poss_gp[i++] = poss_gp_noswap[j++] = poss_gp_para[k++] =
      (unsigned char)make_gp(GST_CLAP, GST_CLAP);

  for (left = GST_NOTHING; left <= GST_CLAP; left++) {
    for (right = GST_NOTHING; right <= GST_CLAP; right++) {
      /* don't consider nothing with both hands (useless), knife with
       * both hands (can't be done), palm with both hands (surrender),
       * or clap with both hands (already added)
       */
      if (left == right &&
          (left == GST_NOTHING ||
           left == GST_KNIFE ||
           left == GST_PALM ||
           left == GST_CLAP)) {
        continue;
      }

      poss_gp_para[k++] = (unsigned char)make_gp(left, right);

      /* except when paralysed, never consider doing nothing or a
       * half-clap
       */
      if (left == GST_NOTHING || left == GST_CLAP ||
          right == GST_NOTHING || right == GST_CLAP) {
        continue;
      }

      poss_gp[i++] = (unsigned char)make_gp(left, right);

      if (left <= right) {
        poss_gp_noswap[j++] = (unsigned char)make_gp(left, right);
      }

      /* when confused, don't consider deliberately making a palm
       * gesture (in case our otherhand also accidently makes a palm
       * gesture) */
      if (left == GST_PALM || right == GST_PALM) {
        continue;
      }

      poss_gp_confused[l++] = (unsigned char)make_gp(left, right);
    }
  }

  if (i != MAX_POSS_GP) {
    printf("Error in init_poss_gp: "
             "MAX_POSS_GP should be %d not %d\n",
           i, MAX_POSS_GP);
    exit(1);
  }

  if (j != MAX_POSS_GP_NOSWAP) {
    printf("Error in init_poss_gp: "
             "MAX_POSS_GP_NOSWAP should be %d not %d\n",
           j, MAX_POSS_GP_NOSWAP);
    exit(1);
  }

  if (k != MAX_POSS_GP_PARA) {
    printf("Error in init_poss_gp: "
             "MAX_POSS_GP_PARA should be %d not %d\n",
           k, MAX_POSS_GP_PARA);
    exit(1);
  }

  if (l != MAX_POSS_GP_CONFUSED) {
    printf("Error in init_poss_gp: "
             "MAX_POSS_GP_CONFUSED should be %d not %d\n",
           l, MAX_POSS_GP_CONFUSED);
    exit(1);
  }

  poss_gp[i] = 0;
  poss_gp_noswap[j] = 0;
  poss_gp_para[k] = 0;
}

void init_gestures(void) {
  init_poss_gp();
}
