/*
 *  Many parts taken from GTetrinet
 *  Copyright (C) 1999, 2000, 2001, 2002, 2003  Ka-shu Wong (kswong@zip.com.au)
 *  Copyright (C) 2003 Chris Yeoh (cyeoh@samba.org)
 *  Copyright (C) 2003 Jeremy Kerr (jeremy@redfishsoftware.com.au)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "client.h"

#include <netinet/in.h>
#include <assert.h>
#define _GNU_SOURCE
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <sys/socket.h>
#include <stdlib.h>

#include "log.h"

static int sd; 

int client_init(int s, char *nick)
{
	char s1[81], s2[81], iphashbuf[12];
	unsigned char ip[4];
	struct sockaddr_in sin;
	unsigned int len, i, l;

	sd = s;

	/*if (gamemode == TETRIFAST)
		g_string_printf(s1, "tetrifaster %s 1.13", nick);
	else*/
	sprintf(s1, "tetrisstart %s 1.13", nick);

	/* do that encoding thingy */
	len = sizeof(struct sockaddr_in);
	
	getpeername(sd, (struct sockaddr *)&sin, &len);
	memcpy(ip, &sin.sin_addr, 4);
	sprintf(iphashbuf, "%d",
			ip[0] * 54 + ip[1] * 41 + ip[2] * 29 + ip[3] * 17);
	l = strlen(iphashbuf);

	*s2 = '\0';
	for(i = 0; s1[i]; i++) {
		s2[i+1] = (((s2[i] & 0xFF) +
                            (s1[i] & 0xFF)) % 255) ^
                            iphashbuf[i % l];
	}
	assert(strlen(s1) == i);
	/*assert(strlen(s2) == i+1);*/
	len = i + 1;
	
	for (i = 0; i < len; i++)
		sprintf(s1+(i*2), "%02X", s2[i] & 0xff);

	client_send(s1, strlen(s1));

	return 0;
}

int client_send(unsigned char *buf, unsigned int len)
{
	char eof;
	int haveWritten = 0;
	int ret;

#ifdef DEBUG
	printf("< %s\n", buf);
#endif
	while (haveWritten<len)
	{
		ret = write(sd, buf+haveWritten, len-haveWritten);
		if (ret<0)
		{
			perror("Error on write - lost connection to tetrinet server?");
			return -1;
		}
		haveWritten += ret;
	}
	eof = 0xff;

	while (haveWritten!=1)
	{
		haveWritten = write(sd, &eof, 1);
		if (haveWritten<0)
		{
			perror("Error on write - lost connection to tetrinet server?");
			return -1;
		}
	}
	return 0;
}

int client_receive(unsigned char *buf, unsigned int len)
{
	int ret;
	int haveFF = 0;
	int haveRead = 0;

	while (!haveFF)
	{
		ret = read(sd, buf + haveRead, len-haveRead);
		if (ret < 0) {
			perror("read");
			return 0;
		} else if (ret == 0) {
			printf("disconnect\n");
			exit(0);
		} else {
			int i = 0;
			haveRead += ret;
			*(buf + haveRead) = '\0';
			for (i=0; i<haveRead; i++)
				if (buf[i]==255) 
				{
					haveFF = i;
					tbt_log(TBT_LOG_NOISY, "FF marker at %i\n", i);
				}
		}
	}
	tbt_log(TBT_LOG_LOW, "%d> %s\n", haveRead, buf);
	return haveRead;
}

int send_special(int to_player, const char *special, int from_player)
{
	char *msg;
	int ret;
	asprintf(&msg, "sb %i %s %i", to_player, special, from_player);
	ret = client_send(msg, strlen(msg));
	free(msg);
	return ret;
}


