#ifndef __TETRIS_H
#define __TETRIS_H

/* Copied from gtetrinet code base 
 * Adds following copyright notice 
 *  Copyright (C) 1999, 2000, 2001, 2002, 2003  Ka-shu Wong (kswong@zip.com.au)
 */

typedef char TETRISBLOCK[4][4];
typedef char (*P_TETRISBLOCK)[4];

// extern void tetris_drawcurrentblock (void);

extern int randomnum (int n);

/* Puts pending block onto field */
extern int tetris_makeblock (int block, int orient, FIELD field);
/* Returns 0 on sucess, 1 if no room for the block,
	 eg player is dead */

extern int tetris_randomorient (int block);


extern P_TETRISBLOCK tetris_getblock (int block, int orient);

/* Move block down one place */
extern int tetris_blockdown (FIELD field);
/* returns -1 if block solidifies, 0 otherwise */

/* Move block */
extern int tetris_blockmove (int dir, FIELD field);
/* returns -1 if block obstructed, 0 otherwise */

/* Rotate block */
extern int tetris_blockrotate (int dir, FIELD field);
/* returns -1 if block obstructed, 0 otherwise */

extern void tetris_blockdrop (FIELD field);

extern int tetris_solidify (FIELD field);
/* returns -1 if player died, 0 otherwise */

extern int tetris_addlines (int count, int type, FIELD field);
/* type - 1 -> original tetrinet
     	 - 2 -> classic mode */
/* returns -1 if player died */

extern int tetris_removelines (char *specials, FIELD field);
/* How big is the special array meant to be? */
/* Returns number of lines removed */

// extern void copyfield (FIELD dest, FIELD src);

/* Current falling block */
extern int get_current_block(void);
extern int get_current_orient(void);
extern void get_current_block_position(int *x, int *y);

/* Pending block */
extern void tetris_make_pending_block(void);
extern int tetris_pending_block(void);
extern int tetris_pending_block_orient(void);

/* adds random special block to the field */
void tetrinet_addsbtofield (int count, FIELD field);

/* Block frequencies */
void tetris_set_block_frequencies(int block_frequencies[7]);
void tetris_set_block_special_frequencies(int block_frequencies[9]);

/* Specials */
void tetris_set_num_specials(int Max);
void tetris_add_special(char Special);
void tetris_delete_first_special(void);
char *tetris_get_specials(void);

/* Player alive or dead */
int tetris_player_is_dead(void);
void tetris_set_player_state(int State);
/* 0 alive, 1 dead */

void tetris_create_dead_field(FIELD field);

#endif
