#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <termios.h>

#include "tclient.h"

struct TC_GameData *gdata;
char *Specials = NULL;
int status = 0;

void GetStatus()
{
	int blocktype, xpos, ypos, pendingblock, i, j;
	char *field;

	printf("Own player number is %i\r\n",
				 GetOwnPlayerNumber(gdata));
	field = GetField(GetOwnPlayerNumber(gdata));

	if (!field) 
	{
		printf("player is dead\r\n");
		status = 1;
		return;
	}

	printf("\r\n");
	for (i=0; i<TC_FIELD_HEIGHT; i++)
	{
		for (j=0; j<TC_FIELD_WIDTH; j++)
		{
			printf("%i", field[i*TC_FIELD_WIDTH+j]);
		}
		printf("\r\n");
	}
	
	GetCurrentBlock(&blocktype, &xpos, &ypos);
	GetNextBlock(&pendingblock);
	
	printf("\r\nCurrent block %i, Position %i %i\r\n", blocktype, xpos, ypos);
	printf("Pending block %i\r\n", pendingblock);

	if (!Specials)
	{
		Specials = (char *)malloc(GetMaxSpecials(gdata));
		printf("Max specials = %i\r\n", GetMaxSpecials(gdata));
	}
	GetSpecials(Specials);
	printf("Specials: ");
	i=0;
	while (Specials[i]!=0)
	{
		printf(" %i", Specials[i]);
		i++;
	}
	printf("\r\n");
}

int main(int argc, char *argv[])
{
	char key;
	struct termios terminal;

	if (connectToServer("localhost", 9467, "tuser", "team", "")<0)
	{
		printf("error: %s\n", tc_error_string);
		exit(1);
	}
	else
	{
		printf("success\n");
	}

	printf("Waiting for game start\n");
	if (Start(&gdata) != 0)
	{
		printf("Game start failed\n");
	}
	else
	{
		printf("Game starting\n");
	}

	if (tcgetattr(0, &terminal)!=0)
	{
		perror("tcgetattr failed");
	}
	cfmakeraw(&terminal);
	terminal.c_lflag &= ~(ECHONL|ICANON);
	if (tcsetattr(0, TCSANOW, &terminal)!=0)
	{
		perror("tcsetattr failed");
	}


	while (1)
	{
		printf("loop\r\n");
		read(0, &key, 1);

		switch (key)
		{
		case ' ':
			MoveBlock(TC_MOVE_DROP);
			break;

		case 'a':
			MoveBlock(TC_MOVE_LEFT);
			break;

		case 's':
			MoveBlock(TC_MOVE_RIGHT);
			break;

		case 'q':
			MoveBlock(TC_ROTATE_CLOCKWISE);
			break;

		case 'w':
			MoveBlock(TC_ROTATE_ANTICLOCKWISE);
			break;

		case 'x':
			MoveBlock(TC_MOVE_DOWN);
			break;

		case 'l':
			GetStatus();

			break;

		case 'k':
			exit(0);

		}
	}

	exit(0);
}
