/*
 *  Copyright (C) 2003 Chris Yeoh (cyeoh@samba.org)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   /Speciathe Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
    
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
    
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <termios.h>

#include "tclient.h"
#include "btetris.h"
#include "useless.h"

struct TC_GameData *gdata;
char *Specials = NULL;
int status = 0;
int setting_up_switch = 0;
int g_own_player_number = 0;

struct FieldParams
{
int block_bomb_num_blocks;
int field_value;

};

void TranslateToLocalRep(int blocktype, int *lblock, int *orientation);

void getOwnSpecials(char *specials, char *ownSpecials) 
{
  int i;
  for (i=0; i<9; i++) {
		ownSpecials[i] = 0;
  }
  for (i=0; specials[i] != 0; i++) {
	  ownSpecials[specials[i]-TC_SPECIAL_FIRST_SPECIAL]++;
	}
}

void PrintSpecials(char *specials)
{
  int i;
  printf("Specials are: ");
  for(i = 0; specials[i] != 0; i++)
  {
    switch(specials[i])
    {
      case TC_SPECIAL_CLEAR_LINE:
        printf("c");
        break;
      case TC_SPECIAL_BLOCK_GRAVITY:
        printf("g");
        break;
      case TC_SPECIAL_NUKE:
        printf("n");
        break;
      case TC_SPECIAL_SWITCH_FIELDS:
        printf("s");
        break;
      case TC_SPECIAL_ADD_LINE:
        printf("a");
        break;
      case TC_SPECIAL_BLOCK_BOMB:
        printf("o");
        break;
      case TC_SPECIAL_CLEAR_RANDOM:
        printf("r");
        break;
      case TC_SPECIAL_CLEAR_SPECIALS:
        printf("b");
        break;
      case TC_SPECIAL_BLOCK_QUAKE:
        printf("q");
        break;
    }
  }
  printf(" -- \n");
}

void PrintField(FIELD field)
{
#ifdef DEBUG
	int i,j;
	char display;

	printf("\n");
	for (i=0; i<TC_FIELD_HEIGHT; i++)
	{
		for (j=0; j<TC_FIELD_WIDTH; j++)
		{
			display = field[i][j];
			display += 48;
			printf("%c", display);
		}
		printf("\n");
	}
#endif
}

int FieldValue(FIELD field, int *NumHoles, int *Height, int *SpecialsCount, struct FieldParams *fieldParams)
{
	int max_height = TC_FIELD_HEIGHT; /* which is actually a minimum */
	int lowest_height = 0;
	int num_buried_holes = 0;
	int well_count_4 = 0;
	int well_count_3 = 0;
	int well_count_5 = 0;
	int x, y;
  
	int got_block;
	int well_accum, well_started_left, well_started_right;
	int goodness = 0;
	int lh_col;
	int max_well_depth = 0;
	int i, j;
	int max_height_for_column[TC_FIELD_WIDTH];
	int jaggedness = 0;

	if (SpecialsCount)
	{
		for (i=TC_SPECIAL_FIRST_SPECIAL; i<=TC_SPECIAL_LAST_SPECIAL; i++)
		{
			SpecialsCount[i-TC_SPECIAL_FIRST_SPECIAL] = 0;
		}
	}

	for (x=0; x<TC_FIELD_WIDTH; x++)
	{
		max_height_for_column[x] = TC_FIELD_HEIGHT;

		if (x==0)	well_started_left = 1;
		else if (x==TC_FIELD_WIDTH-1) well_started_right = 1;
		else
		{
			well_started_left = 0;
			well_started_right =0;

		}
		for (y=0, got_block=0, well_accum=0, lh_col=0,
					 well_started_right = 0; y<TC_FIELD_HEIGHT; y++)
		{

      /* check for block bombs */
      if(fieldParams)
      {
        fieldParams->block_bomb_num_blocks = 0;
        if(field[y][x] == TC_SPECIAL_BLOCK_BOMB)
        {
          printf("starting block count-");
          for(j = ((y > 0) ? y - 1 : 0); j <= ((y < TC_FIELD_HEIGHT - 1) ? y + 1 : TC_FIELD_HEIGHT - 1); j++)
          {
            for(i = ((x > 0) ? x - 1 : 0); i <= ((x < TC_FIELD_WIDTH - 1) ? x + 1 : TC_FIELD_WIDTH - 1); i++)
            {
              if(field[j][i] != 0 && field[j][i] < TC_SPECIAL_FIRST_SPECIAL)
              {
                fieldParams->block_bomb_num_blocks++;
              }
            }
          }
          printf("blocks found = %d\n", fieldParams->block_bomb_num_blocks);
        }
      }
			/* Look for buried holes */
			if (field[y][x]) 
			{
				got_block = 1;
				if (y<max_height) max_height = y;
				if (y<max_height_for_column[x]) max_height_for_column[x] = y;
				if (!lh_col && y>lowest_height) 
				{
					lh_col = 1;
					lowest_height = y;
				}
				well_accum = 0;

				if (field[y][x]>=TC_SPECIAL_FIRST_SPECIAL && SpecialsCount)
				{
					SpecialsCount[field[y][x]-TC_SPECIAL_FIRST_SPECIAL]++;
				}
			}
			else 
			{
				if (got_block) num_buried_holes++;
			
				/* well detection */
				if (x>0 && field[y][x-1] && !well_started_left) well_started_left = 1;
				if (x<TC_FIELD_WIDTH-1 && field[y][x+1] && !well_started_right)
					well_started_right = 1;
				if (well_started_left && well_started_right) well_accum++;
				if (well_accum==3) well_count_3++;
				if (well_accum==4)
				{
					well_count_3--;
					well_count_4++;
				}
				if (well_accum==5)
				{
					well_count_5++;
					well_count_4--;
				}
				if (well_accum>max_well_depth) max_well_depth = well_accum;
			}
		}
	}


	max_height = TC_FIELD_HEIGHT-max_height-1;
	lowest_height = TC_FIELD_HEIGHT-lowest_height-1;
	goodness = 0;
	goodness -= num_buried_holes*VAR_WEIGHTING_BURIED_HOLES;
	printf("weight of buried holes: %d\n",VAR_WEIGHTING_BURIED_HOLES);

	/* Only more than one well is bad */
/* 	if (well_count_3 + well_count_4 > 1) */
/* 	{ */
	goodness -= (well_count_3+well_count_4*30);
/* 	} */

	/* See how jagged our field looks like */
	for (x=1; x<TC_FIELD_WIDTH; x++)
	{
		jaggedness += abs(max_height_for_column[x]-max_height_for_column[x-1]);
	}
	
	goodness -= jaggedness*10;

	goodness -= max_height*20;
	if (max_height>10) goodness -= (max_height-10)*(max_height-10)*10;

	/* Don't like too much unevenness */
	if (max_height-lowest_height>5)
		goodness -= (max_height - lowest_height - 5)*50;

	/* Really deep wells are bad */
	if (max_well_depth>5)
		goodness -= (max_well_depth-5)*(max_well_depth-5)*20;

	PrintField(field);
/*	printf("Ht=%i, bh=%i, w3=%i, w4=%i, gd %i\n", max_height,
				 num_buried_holes, well_count_3, well_count_4, goodness);
*/


	if (NumHoles) *NumHoles = num_buried_holes;
	if (Height) *Height = max_height;

	return goodness;

}

int GetBestMove(int block, int xpos, int ypos, int orientation, FIELD field,
								 int *best_position, int *best_orientation, int recurse,
								int best_value)
{
	FIELD tmp_field;
	int rotation;
	int minx, maxx;
	int field_value;
	int lines_removed;
	int next_block;
	int next_orientation;
  struct FieldParams own_field_params;

/* 	printf("Input field\n"); */
/* 	PrintField(field); */
/* 	printf("Given block %i, orientation %i\n", block, orientation); */


  if(setting_up_switch)
  {
    printf("setting up switch!!!\n");
  }
	if (recurse)
	{
		int rnb;
		GetNextBlock(&rnb);
		TranslateToLocalRep(rnb, &next_block, &next_orientation);
		printf("Next block is %i %i %i\n", rnb, next_block, next_orientation);
	}

	for (rotation=0; rotation<num_rotations_for_blocktype(block); rotation++)
	{
//		printf("+++++++++++++++++++Rotation\n");
		get_valid_x_positions(block, orientation, &minx, &maxx);
/*  		printf("valid x positions %i %i\n", minx, maxx);  */

		for (xpos = minx; xpos<=maxx; xpos++)
		{
			/* Make a copy of the field */
			memcpy(tmp_field, field, TC_FIELD_SIZE);

			/* Set block to drop */
/* 			printf("Set current block: %i %i %i %i\n",  */
/* 						 block, orientation, xpos, ypos); */
			set_current_block(block, orientation, xpos, ypos);

			/* drop the block */
			tetris_blockdrop(tmp_field);
			tetris_solidify(tmp_field);

			/* Check if line removal will happen */
			lines_removed = tetris_removelines(NULL, tmp_field);

			if (recurse)
			{
				int dummy1, dummy2;

				field_value = GetBestMove(next_block, 4, 0, next_orientation, 
																	tmp_field, &dummy1, &dummy2, 0, best_value)
					+ (lines_removed*lines_removed*100);
			}
			else
			{
				field_value = FieldValue(tmp_field, NULL, NULL, NULL, &own_field_params );
 				field_value += (lines_removed)*(lines_removed)*100; 
			}

      if(setting_up_switch)
      {
       // printf("setting up switch!!!!!!!!!!!!!!!!!!!!!!!!!!\n");
        if(field_value<best_value)
        {
          best_value = field_value;
          *best_position = xpos;
          *best_orientation = orientation;
          if (!recurse)
          {
            printf("*recursed*");
          }
          PrintField(tmp_field);
          printf("************** Found better field %i %i (value %i)\n",
               xpos, orientation, field_value);
        }
      } else {
  			if (field_value>best_value)
	  		{
		  		best_value = field_value;
			  	*best_position = xpos;
			  	*best_orientation = orientation;
				  if (!recurse)
				  {
					  printf("*recursed*");
				  }
				  PrintField(tmp_field);
				  printf("************** Found better field %i %i (value %i)\n",
							 xpos, orientation, field_value);
				
			  }
      }
		}
		
		orientation = get_orientation_after_rotation(block, orientation, 1);

	}
	return best_value;
}


void TranslateToLocalRep(int blocktype, int *lblock, int *orientation)
{
	switch (blocktype)
	{
	case TC_BLOCK_I_1:
		*lblock = 0;
		*orientation = 0;
		return;
		
	case TC_BLOCK_I_2:
		*lblock = 0;
		*orientation = 1;
		return;

	case TC_BLOCK_O:
		*lblock = 1;
		*orientation = 0;
		return;

	case TC_BLOCK_J_1:
		*lblock = 2;
		*orientation = 3;
		return;

	case TC_BLOCK_J_2:
		*lblock = 2;
		*orientation = 2;
		return;

	case TC_BLOCK_J_3:
		*lblock = 2;
		*orientation = 1;
		return;

	case TC_BLOCK_J_4:
		*lblock = 2;
		*orientation = 0;
		return;

	case TC_BLOCK_L_1:
		*lblock = 3;
		*orientation = 1;
		return;

	case TC_BLOCK_L_2:
		*lblock = 3;
		*orientation = 0;
		return;

	case TC_BLOCK_L_3:
		*lblock = 3;
		*orientation = 3;
		return;

	case TC_BLOCK_L_4:
		*lblock = 3;
		*orientation = 2;
		return;

	case TC_BLOCK_Z_1:
		*lblock = 4;
		*orientation = 1;
		return;

	case TC_BLOCK_Z_2:
		*lblock = 4;
		*orientation = 0;
		return;

	case TC_BLOCK_S_1:
		*lblock = 5;
		*orientation = 1;
		return;

	case TC_BLOCK_S_2:
		*lblock = 5;
		*orientation = 0;
		return;

	case TC_BLOCK_T_1:
		*lblock = 6;
		*orientation = 3;
		return;

	case TC_BLOCK_T_2:
		*lblock = 6;
		*orientation = 2;
		return;

	case TC_BLOCK_T_3:
		*lblock = 6;
		*orientation = 1;
		return;

	case TC_BLOCK_T_4:
		*lblock = 6;
		*orientation = 0;
		return;

	default:
		printf("oops in translation\n");
		abort();

	}

}

int HasGoodSpecial(int *Specials)
{
	return Specials[TC_SPECIAL_BLOCK_GRAVITY-TC_SPECIAL_FIRST_SPECIAL]
		|| Specials[TC_SPECIAL_NUKE-TC_SPECIAL_FIRST_SPECIAL]
		|| Specials[TC_SPECIAL_SWITCH_FIELDS-TC_SPECIAL_FIRST_SPECIAL];
}


void UseSpecials(FIELD field)
{
	int field_value;
	int num_holes, field_height;
	char specials[100];
	int i, j, try_another_special = 0, changed_field = 0;
	int num_players;
	char *fields[6];
	int field_values[6];
	int field_specials[6][9];
	int best_field_index = -1;
	int best_field_value = -2000000;
	int use_special_failed;
  struct FieldParams field_params[6];
  struct FieldParams own_field_params;
  int highest_num_blocks;
  int block_bomb_player;
  int ownSpecials[9];
  int break_loop=0;

	GetSpecials(specials);
  PrintSpecials(specials);
  num_players = GetNumPlayers(gdata);

	printf("num players is: %d\n", num_players);
	if (specials[0])
	{
    printf("num players = %d\n", num_players);
		/* Get Fields for all players */
		for (i=0; i<num_players; i++)
		{
			printf("getting field for player %d\n", i);
			if (GetPlayerNumber(GetPlayer(gdata,i))==GetOwnPlayerNumber(gdata))
			{
				fields[i] = NULL;
				field_values[i] = best_field_value;
			} else {
				fields[i] = GetField(GetPlayerNumber(GetPlayer(gdata,i)));
				if (fields[i])
				{
					field_values[i] = FieldValue(fields[i], NULL, NULL, field_specials[i], &(field_params[i]));
				} else {
					field_values[i] = -2000000;
				}

				if (field_values[i]>best_field_value) {
           best_field_index = i;
           best_field_value = field_values[i];
        }
			}
		}

		for (i=0; specials[i]!=0; i++)
		{
			printf("traversing specials array\n");
			field_value = FieldValue(field, &num_holes, &field_height, NULL, &own_field_params);
			try_another_special = 0;
			changed_field = 0;
			getOwnSpecials(specials, ownSpecials);
          
			switch (specials[i])
			{
			case TC_SPECIAL_CLEAR_LINE:
				if (num_holes) 
				{
					use_special_failed = UseSpecial(GetOwnPlayerNumber(gdata));
					try_another_special = 1;
					changed_field = 1;
				}
				break;

			case TC_SPECIAL_BLOCK_GRAVITY:
				if (field_height>15)
				{
					use_special_failed = UseSpecial(GetOwnPlayerNumber(gdata));
					try_another_special = 1;
					changed_field = 1;
				}
				break;

			case TC_SPECIAL_NUKE:
				if (field_height>15) 
				{
					use_special_failed = UseSpecial(GetOwnPlayerNumber(gdata));
					try_another_special = 1;
					changed_field = 1;
				}
				break;

			case TC_SPECIAL_SWITCH_FIELDS:
				if (field_height>15)
				{
          printf("best field value = %d, best field index = %d, field_value = %d\n", best_field_value, best_field_index, field_value);
          printf("all fields: ");
          for(j = 0; j < num_players; j++)
          {
            printf("  %d  ",  field_values[j]);
          }
          printf("\n");
					if (best_field_value-field_value>100)
					{
            printf("Using Switch on %d\n", best_field_index);
						printf("Before the switch, my field is %d\n", field_value);
						use_special_failed = UseSpecial(GetPlayerNumber(GetPlayer(gdata,best_field_index)));
 
						sleep(1);
					  field = GetField(GetOwnPlayerNumber(gdata));
			      field_value = FieldValue(field, &num_holes, &field_height, NULL, &own_field_params);
						printf("After the switch, my field is %d\n", field_value);
						VAR_WEIGHTING_BURIED_HOLES = VAR_WEIGHTING_BURIED_HOLES_ORIG;
            changed_field = 1;
            setting_up_switch = 0;
						/* We sleep to ensure we don't do anything too 
							 fast after switching */
					} else {
            setting_up_switch = 0;
            DiscardSpecial();
            printf("discard switch field height greater 15\n");
            try_another_special = 1;
          }

				} else {
        //  setting_up_switch = 1;
					// Only set up a switch if another players field is better that our field by at least VAR_SWITCH_THRESHOLD
            if (best_field_value-field_value>VAR_SWITCH_THRESHOLD ||
							 ownSpecials[TC_SPECIAL_NUKE-TC_SPECIAL_FIRST_SPECIAL] > 0 ||
							 ownSpecials[TC_SPECIAL_BLOCK_GRAVITY-TC_SPECIAL_FIRST_SPECIAL] > 0 ) { 
							printf("Setting a switch - threshold reached or gravity/nuke in queue\n");
							printf("best_field_value was %d, my field_value was %d\n", best_field_value, field_value);
							VAR_WEIGHTING_BURIED_HOLES = 10000;
              setting_up_switch = 1;
            } else {
							printf("Discarding a switch .. \n");
              DiscardSpecial();
              setting_up_switch = 0;
            }
        }

				break;

			case TC_SPECIAL_CLEAR_SPECIALS:
				for (j=0; j<num_players; j++)
				{
					if (fields[j] && HasGoodSpecial(field_specials[j]))
					{
						use_special_failed = UseSpecial(GetPlayerNumber(GetPlayer(gdata, j)));
						break;
					}
				}
				  use_special_failed = UseSpecial(GetPlayerNumber(GetPlayer(gdata, best_field_index)));
				break;

			case TC_SPECIAL_ADD_LINE:
				use_special_failed = UseSpecial(GetPlayerNumber(GetPlayer(gdata, best_field_index)));
				try_another_special = 1;
				break;

			case TC_SPECIAL_BLOCK_BOMB:
				DiscardSpecial();
				break;
/*        highest_num_blocks = 0;
        block_bomb_player = -1;
				for (j=0; j<num_players; j++)
				{        
					printf("for this player(j=%d) block_bomb_num_blocks is %d\n", j,field_params[j].block_bomb_num_blocks);
          if (field_params[j].block_bomb_num_blocks >= highest_num_blocks && j != g_own_player_number)
          {
            highest_num_blocks = field_params[j].block_bomb_num_blocks;
            block_bomb_player = j;
          }          
				}

        try_another_special = 0;
				printf("the highest num blocks is: %d the player is %d\n", highest_num_blocks,block_bomb_player);
        if(highest_num_blocks > 0)
        {
					printf("using BLOCK BOMB NOW on %d!\n", block_bomb_player);
          use_special_failed = UseSpecial(GetPlayerNumber(GetPlayer(gdata, block_bomb_player)));
					if (use_special_failed) {
						printf("using BLOCK BOMB FAILED :: %d", use_special_failed);
					  DiscardSpecial();
					}
					
          try_another_special = 1;
        } else if(field_height > 15) {
          // check for other good specials..
          for(j = i; specials[j] != 0; j++)
          {
            if(specials[j] == TC_SPECIAL_NUKE || specials[j] == TC_SPECIAL_BLOCK_GRAVITY || specials[j] == TC_SPECIAL_SWITCH_FIELDS)
            {
              DiscardSpecial();
              try_another_special = 1;
              break;
            }
          }

        }
				break;
*/
			case TC_SPECIAL_CLEAR_RANDOM:
				use_special_failed = UseSpecial(GetPlayerNumber(GetPlayer(gdata, best_field_index)));
				try_another_special = 1;
				break;

			case TC_SPECIAL_BLOCK_QUAKE:
				use_special_failed = UseSpecial(GetPlayerNumber(GetPlayer(gdata, best_field_index)));
				try_another_special = 1;
				break;

			}


			/* Have this test here as a failsafe to make sure we exit
				 if the game is over */
			{
				int dummy1, dummy2, dummy3;
				if (GetCurrentBlock(&dummy1, &dummy2, &dummy3)) break;
			}
			if (!try_another_special || use_special_failed) break;
		}
		/* Take evasive maneouvres - don't worry too much about attacking! */
	  GetSpecials(specials);
		getOwnSpecials(specials, ownSpecials);
	  if (field_height>15 && 
			  (ownSpecials[TC_SPECIAL_NUKE-TC_SPECIAL_FIRST_SPECIAL] || 
				 ownSpecials[TC_SPECIAL_BLOCK_GRAVITY-TC_SPECIAL_FIRST_SPECIAL] )) {
			printf("Taking evasive action !!! \n");
			for (i=0; specials[i] != 0; i++) {
			  switch(specials[i]) 
        {
				 case TC_SPECIAL_CLEAR_LINE:
					 use_special_failed = UseSpecial(GetOwnPlayerNumber(gdata));
					 break;
				 case TC_SPECIAL_ADD_LINE:
				 case TC_SPECIAL_BLOCK_QUAKE:
				 case TC_SPECIAL_CLEAR_RANDOM:
				 case TC_SPECIAL_CLEAR_SPECIALS:
				 case TC_SPECIAL_BLOCK_BOMB:
					 printf("Dumping %d on %d\n", specials[i], GetPlayerNumber(GetPlayer(gdata, best_field_index)));
				   use_special_failed = UseSpecial(GetPlayerNumber(GetPlayer(gdata, best_field_index)));
					 break;
				 case TC_SPECIAL_SWITCH_FIELDS:
					 printf("Switching with %d\n", GetPlayerNumber(GetPlayer(gdata, best_field_index)));
				   use_special_failed = UseSpecial(GetPlayerNumber(GetPlayer(gdata, best_field_index)));
					 break_loop = 1;
					 break;
				 case TC_SPECIAL_BLOCK_GRAVITY:
				 case TC_SPECIAL_NUKE:
					 printf("Nuking/Grav'ing\n");
					 use_special_failed = UseSpecial(GetOwnPlayerNumber(gdata));
					 break_loop = 1;
					 break;
			 }
				if (break_loop==1) {
					break_loop=0;
				  break;
		 		}
		 } //end for
	 } // end if
  }
}


int main(int argc, char *argv[])
{
	char *username = "useless";
	char *field;
	int blocktype, xpos, ypos;
	int localblocktype, orientation;
	int use_offset, use_orientation;
	int i, status;

	if (argc>1)
	{
		username = argv[1];
	}

	if (connectToServer("localhost", 9467, username, "", "")<0)
	{
		printf("error: %s\n", tc_error_string);
		exit(1);
	}
	else
	{
		printf("success\n");
	}

	while (1)
	{
		printf("Waiting for game start\n");
		if (Start(&gdata) != 0)
		{
			printf("Game start failed\n");
			exit(1);
		}
		else
		{
			printf("Game starting\n");
		}


    g_own_player_number = GetOwnPlayerNumber(gdata);
		printf("my player number is %d\n", g_own_player_number);

		while (1)
		{
			status = GetCurrentBlock(&blocktype, &xpos, &ypos);
		
			if (status==1)
			{
				printf("*** We lost! ***\n");
				printf("========================================================\n");
				break;
			}
			else if (status==2)
			{
				printf("========================================================\n");
				printf("*** We won! ***\n");
				break;
			}

			if (blocktype==TC_BLOCK_NONE) 
			{
				usleep(200000);
				continue;
			}
			else
			{
				printf("--------------------------------------------------\n");
				printf("Got block %i\n", blocktype);

			}

			field = GetField(GetOwnPlayerNumber(gdata));

//			printf("************************Have field\n");
			PrintField(field);
			TranslateToLocalRep(blocktype, &localblocktype, &orientation);

			GetBestMove(localblocktype, xpos, ypos, orientation, field, &use_offset,
									&use_orientation, 0, -20000);

/*			printf("**** Think best position is %i and orientation is %i\n",
						 use_offset, use_orientation);
			printf("**** Current position %i and orientation is %i\n",
						 xpos, orientation);
*/

			for (i=orientation; i!=use_orientation; 
					 orientation<use_orientation ? i++ : i--)
			{
				MoveBlock(orientation<use_orientation ? TC_ROTATE_CLOCKWISE
									: TC_ROTATE_ANTICLOCKWISE);
			}
			for (i=xpos; i!=use_offset; xpos<use_offset ? i++ : i--)
			{
				MoveBlock(xpos<use_offset ? TC_MOVE_RIGHT : TC_MOVE_LEFT);
			}
			MoveBlock(TC_MOVE_DROP);

			/* Specials on self? */
			UseSpecials(field);
		}
	}	

		exit(0);
}
