#ifndef PLAYER_H_
#define PLAYER_H_

#include "tclient.h"

#define MAX_NUM_PLAYERS 6
#define TC_NUM_SPECIALS (TC_SPECIAL_LAST_SPECIAL - TC_SPECIAL_FIRST_SPECIAL + 1)


extern int g_num_players;
extern int g_num_alive_players;

struct PlayerData
{
int   m_player_number;
char  m_player_name[1024];
int   m_player_is_me;
int   m_player_active;
int   m_field_height;
float m_field_merit;
char *m_field;
int   m_field_specials[TC_NUM_SPECIALS];
int   m_player_specials[TC_NUM_SPECIALS];
char  m_specials[100];
};

extern struct PlayerData g_player_data[MAX_NUM_PLAYERS];
extern struct PlayerData *g_player_order[MAX_NUM_PLAYERS];
extern struct PlayerData *g_my_player_data;

void InitPlayerData(struct TC_GameData *tc_game_data);
void UpdatePlayerData(void);
void CleanUpPlayerData(void);

int HasSpecial(struct PlayerData *player_data, int special);

void ReadFieldSpecials(char *field, int *specials);
void UpdatePlayerSpecials(char *field, struct PlayerData *player_data);


#endif


