#include <stdio.h>
#include <stdlib.h>
#include <string.h>


extern float g_shadowedHolesWeight_orig;
extern float g_shadowedHolesWeight;
extern float g_pileHeightWeight;
extern float g_sumOfWellHeightsWeight;

void SetToDefaults(void)
{
  g_shadowedHolesWeight_orig = -0.65f;
  g_shadowedHolesWeight = -0.65f;
  g_pileHeightWeight = -0.10f;
  g_sumOfWellHeightsWeight = -0.20f;
}

void PrintValues(void)
{
  printf("shadowed holes weight = %f\n", g_shadowedHolesWeight);
  printf("pile height weight = %f\n", g_pileHeightWeight);
  printf("well heights weight = %f\n", g_sumOfWellHeightsWeight);

}

void SetValue(char *parameter, char *value)
{
  printf("got value='%s'\n", value);
  if(strcmp(parameter, "SHADOWED_HOLES_WEIGHT") == 0)
  {
    g_shadowedHolesWeight = (float)atof(value);
    printf("set to %f\n", g_shadowedHolesWeight);
  }

  if(strcmp(parameter, "PILE_HEIGHT_WEIGHT") == 0)
    g_pileHeightWeight = atof(value);

  if(strcmp(parameter, "WELL_HEIGHT_WEIGHT") == 0)
    g_sumOfWellHeightsWeight = atof(value);
}


int ReadSettings(char *filename)
{
  FILE *file;
  char c;
  char parameter[1024];
  char value[1024];
  int i = 0;
  int readingValue = 0;


  SetToDefaults();

  file = fopen(filename, "r");
  if(file != NULL)
  {
    while((c = fgetc(file)) != -1)
    {
      switch(c)
      {
        case '\n':
          value[i] = '\0';
          i = 0;
          readingValue = 0;
          if(strlen(parameter) > 0 && strlen(value) > 0)
            SetValue(parameter, value);
        break;
        case ' ':
        case '\t':
        break;
        case '=':
          parameter[i] = '\0';
          readingValue = 1;
          i = 0;
        break;
        default:
          if(readingValue)
            value[i++] = c;
          else
            parameter[i++] = c;
        break;
      }
    }
  } else {
    return 0;
  }

  return 1;
}


