/*
 *  Many parts taken from GTetrinet
 *  Copyright (C) 1999, 2000, 2001, 2002, 2003  Ka-shu Wong (kswong@zip.com.au)
 *  Copyright (C) 2003 Chris Yeoh (cyeoh@samba.org)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <string.h>
#include <stdlib.h>
#include <stdio.h>

/* #include "client.h" */
/* #include "tetrinet.h" */
#include "btetris.h"


TETRISBLOCK b1[2] = {
    {
        {1,1,1,1},
        {0,0,0,0},
        {0,0,0,0},
        {0,0,0,0}
    }, {
        {0,0,1,0},
        {0,0,1,0},
        {0,0,1,0},
        {0,0,1,0}
    }
};

TETRISBLOCK b2[1] = {
    {
        {0,2,2,0},
        {0,2,2,0},
        {0,0,0,0},
        {0,0,0,0}
    }
};

TETRISBLOCK b3[4] = {
    {
        {0,0,3,0},
        {0,0,3,0},
        {0,3,3,0},
        {0,0,0,0}
    }, {
        {0,3,0,0},
        {0,3,3,3},
        {0,0,0,0},
        {0,0,0,0}
    }, {
        {0,3,3,0},
        {0,3,0,0},
        {0,3,0,0},
        {0,0,0,0}
    }, {
        {0,3,3,3},
        {0,0,0,3},
        {0,0,0,0},
        {0,0,0,0}
    }
};

TETRISBLOCK b4[4] = {
    {
        {0,4,0,0},
        {0,4,0,0},
        {0,4,4,0},
        {0,0,0,0}
    }, {
        {0,4,4,4},
        {0,4,0,0},
        {0,0,0,0},
        {0,0,0,0}
    }, {
        {0,4,4,0},
        {0,0,4,0},
        {0,0,4,0},
        {0,0,0,0}
    }, {
        {0,0,0,4},
        {0,4,4,4},
        {0,0,0,0},
        {0,0,0,0}
    }
};


TETRISBLOCK b5[2] = {
    {
        {0,0,5,0},
        {0,5,5,0},
        {0,5,0,0},
        {0,0,0,0}
    }, {
        {0,5,5,0},
        {0,0,5,5},
        {0,0,0,0},
        {0,0,0,0}
    }
};

TETRISBLOCK b6[2] = {
    {
        {0,1,0,0},
        {0,1,1,0},
        {0,0,1,0},
        {0,0,0,0}
    }, {
        {0,0,1,1},
        {0,1,1,0},
        {0,0,0,0},
        {0,0,0,0}
    }
};
TETRISBLOCK b7[4] = {
    {
        {0,0,2,0},
        {0,2,2,0},
        {0,0,2,0},
        {0,0,0,0}
    }, {
        {0,0,2,0},
        {0,2,2,2},
        {0,0,0,0},
        {0,0,0,0}
    }, {
        {0,2,0,0},
        {0,2,2,0},
        {0,2,0,0},
        {0,0,0,0}
    }, {
        {0,2,2,2},
        {0,0,2,0},
        {0,0,0,0},
        {0,0,0,0}
    }
};
static TETRISBLOCK *blocks[7] = { b1, b2, b3, b4, b5, b6, b7 };
static int blockcount[7] = { 2, 1, 4, 4, 2, 2, 4 };

static int blocknum = -1, blockorient; /* which block */
static int blockx, blocky; /* current location of block */

static int blockobstructed (FIELD field, int block, int orient, int bx, int by);
static int obstructed (FIELD field, int x, int y);
static void placeblock (FIELD field, int block, int orient, int bx, int by);


P_TETRISBLOCK tetris_getblock (int block, int orient)
{
    return blocks[block][orient];
}

/* returns -1 if block solidifies, 0 otherwise */
int tetris_blockdown (FIELD field)
{
/* 	printf("block %i pos %i %i\n", blocknum, blockx, blocky); */
    if (blocknum < 0) return 0;
    /* move the block down one */
    if (blockobstructed (field, blocknum, blockorient, blockx, blocky+1))
    {
        /* cant move down */
#ifdef DEBUG
			printf ("blockobstructed: %d %d\n", blockx, blocky);
#endif
			return -1;
    }
    else 
		{
			blocky ++;
			return 0;
    }
}

int tetris_blockmove (int dir, FIELD field)
{
	if (blocknum < 0) return -1;
	if (blockobstructed(field, blocknum,  blockorient, blockx+dir, blocky))
	{
    /* do nothing */;
		return -1;
	}
	else
	{
    blockx += dir;
		return 0;
	}
}

int tetris_blockrotate (int dir, FIELD field)
{
	int neworient = blockorient + dir;
	if (blocknum < 0) return -1;
	if (neworient >= blockcount[blocknum]) neworient = 0;
	if (neworient < 0) neworient = blockcount[blocknum] - 1;
	switch (blockobstructed(field, blocknum, neworient, blockx, blocky))
	{
	case 1: return -1; /* cant rotate if obstructed by blocks */
	case 2: /* obstructed by sides - move block away if possible */
	{
		int shifts[4] = {1, -1, 2, -2};
		int i;
		for (i = 0; i < 4; i ++) {
			if (!blockobstructed (field, blocknum,
														neworient, blockx+shifts[i],
														blocky))
			{
				blockx += shifts[i];
				goto end;
			}
		}
		return -1; /* unsuccessful */
	}
	}
end:
	blockorient = neworient;
	return 0;
}

void tetris_blockdrop (FIELD field)
{
	if (blocknum < 0) return;
	while (tetris_blockdown(field) == 0);
}

/* this function removes full lines */
int tetris_removelines (char *specials, FIELD field)
{
    int x, y, o, c = 0, i;

    /* remove full lines */
    for (y = 0; y < FIELD_HEIGHT; y ++) {
        o = 0;
        /* count holes */
        for (x = 0; x < FIELD_WIDTH; x ++)
            if (field[y][x] == 0) o ++;
        if (o) continue; /* if holes */
        /* no holes */
        /* increment line count */
        c ++;
        /* grab specials */
        if (specials)
            for (x = 0; x < FIELD_WIDTH; x ++)
                if (field[y][x] > 5)
								{
									*specials++ = field[y][x];
									printf("******** Got a special %i\n", field[y][x]);
								}
        /* move field down */
        for (i = y-1; i >= 0; i --)
            for (x = 0; x < FIELD_WIDTH; x ++)
                field[i+1][x] = field[i][x];
        /* clear top line */
        for (x = 0; x < FIELD_WIDTH; x ++)
            field[0][x] = 0;
    }
    if (specials) *specials = 0; /* null terminate */
    return c;
}

int tetris_solidify (FIELD field)
{
    if (blocknum < 0) return 0;
    if (blockobstructed (field, blocknum, blockorient, blockx, blocky)) {
        /* move block up until we get a free spot */
        for (blocky --; blocky >= 0; blocky --)
            if (!blockobstructed (field, blocknum, blockorient, blockx, blocky))
            {
                placeblock (field, blocknum, blockorient, blockx, blocky);
                break;
            }
        if (blocky < 0) {
            /* no space - player has lost */
            blocknum = -1;
            return -1;
        }
    }
    else {
        placeblock (field, blocknum, blockorient, blockx, blocky);
    }
    blocknum = -1;
		return 0;
}

static int blockobstructed (FIELD field, int block, int orient, int bx, int by)
{
    int x, y, side = 0;
    for (y = 0; y < 4; y ++)
        for (x = 0; x < 4; x ++)
            if (blocks[block][orient][y][x]) {
                switch (obstructed (field, bx+x, by+y)) {
                case 0: continue;
                case 1: return 1;
                case 2: side = 2;
                }
            }
    return side;
}

static int obstructed (FIELD field, int x, int y)
{
    if (x < 0) return 2;
    if (x >= FIELD_WIDTH) return 2;
    if (y < 0) return 1;
    if (y >= FIELD_HEIGHT) return 1;
    if (field[y][x]) return 1;
    return 0;
}

static void placeblock (FIELD field, int block, int orient, int bx, int by)
{
    int x, y;
    for (y = 0; y < 4; y ++)
        for (x = 0; x < 4; x ++) {
            if (blocks[block][orient][y][x])
                field[y+by][x+bx] = blocks[block][orient][y][x];
        }
}

int get_current_block()
{
	return blocknum;
}

int get_current_orient()
{
	return blockorient;
}

void get_current_block_position(int *x, int *y)
{
	*x = blockx;
	*y = blocky;
}

void set_current_block(int block, int orientation, int x, int y)
{
	blocknum = block;
	blockorient = orientation;
	blockx = x;
	blocky = y;
}

int num_rotations_for_blocktype(int block)
{
	return blockcount[block];
}


void get_valid_x_positions(int block, int orientation, int *minx, int *maxx)
{
	switch (block)
	{
	case 0:
		switch (orientation)
		{
		case 0:
			*minx = 0;
			*maxx = 8;
			break;

		case 1:
			*minx = -2;
			*maxx = 9;
			break;

		}
		break;

	case 1:
		*minx = -1;
		*maxx = 9;
		break;

	case 2:
		switch (orientation)
		{
		case 0:
			*minx = -1;
			*maxx = 9;
			break;

		case 1:
			*minx = -1;
			*maxx = 8;
			break;

		case 2:
			*minx = -1;
			*maxx = 9;
			break;

		case 3:
			*minx = -1;
			*maxx = 8;
			break;
		}
		break;

	case 3:
		switch (orientation)
		{
		case 0:
			*minx = -1;
			*maxx = 9;
			break;

		case 1:
			*minx = -1;
			*maxx = 8;
			break;

		case 2:
			*minx = -1;
			*maxx = 9;
			break;

		case 3:
			*minx = -1;
			*maxx = 8;
			break;
		}
		break;

	case 4:
		switch (orientation)
		{
		case 0:
			*minx = -1;
			*maxx = 9;
			break;

		case 1:
			*minx = -1;
			*maxx = 8;
			break;
		}
		break;

	case 5:
		switch (orientation)
		{
		case 0:
			*minx = -1;
			*maxx = 9;
			break;

		case 1:
			*minx = -1;
			*maxx = 8;
			break;
		}
		break;

	case 6:
		switch (orientation)
		{
		case 0:
			*minx = -1;
			*maxx = 9;
			break;

		case 1:
			*minx = -1;
			*maxx = 8;
			break;

		case 2:
			*minx = -1;
			*maxx = 9;
			break;

		case 3:
			*minx = -1;
			*maxx = 8;
			break;
		}		
	}

	return;
}


void get_possible_block_x_positions(FIELD field, int block, int orient, int x, int y, int *possible_min_x, int *possible_max_x)
{
  int min_x, max_x;
  int i;


  get_valid_x_positions(block, orient, &min_x, &max_x);

  *possible_min_x = min_x;
  *possible_max_x = max_x;

  for(i = x; i >= min_x; i--)
  {
    if(blockobstructed(field, block, orient, i, y))
    {
      *possible_min_x = i + 1;
      break;
    }
  }

  for(i = x; i <= max_x; i++)
  {
    if(blockobstructed(field, block, orient, i, y))
    {
      *possible_max_x = i--;
      break;
    }
  }
}


int get_orientation_after_rotation(int block, int orientation, int rotation)
{
	int neworient = orientation + rotation;
	if (neworient >= blockcount[block]) neworient = 0;
	if (neworient < 0) neworient = blockcount[block] - 1;
	return neworient;
}
