#include "TetrinetField.h"
#include "TetrinetServer.h"
#include <stdio.h>
#include <malloc.h>
#include <iostream>
#include <stack>
using namespace std;

TetrinetField::TetrinetField(char *field)
{
	this->field=field;
}

TetrinetField::TetrinetField(TetrinetField &i, bool copy)
{
	if(copy)
	{
		field=(char *)malloc(TC_FIELD_HEIGHT*TC_FIELD_WIDTH);
		memcpy(field, i.field, TC_FIELD_HEIGHT*TC_FIELD_WIDTH);
	}
	else
	{
		field=i.field;
	}
}

TetrinetField::TetrinetField(TetrinetField *i, bool copy)
{
	if(copy)
	{
		field=(char *)malloc(TC_FIELD_HEIGHT*TC_FIELD_WIDTH);
		memcpy(field, i->field, TC_FIELD_HEIGHT*TC_FIELD_WIDTH);
	}
	else
	{
		field=i->field;
	}
}

bool TetrinetField::isEqual(TetrinetField *i)
{
	for(int y=0;y<TC_FIELD_HEIGHT;y++)
	{
		for(int x=0;x<TC_FIELD_WIDTH;x++)
		{
			if( field[y*TC_FIELD_WIDTH+x]!=0 &&
			    i->field[y*TC_FIELD_WIDTH+x]==0)
				return false;
			if(field[y*TC_FIELD_WIDTH+x]==0 &&
			   i->field[y*TC_FIELD_WIDTH+x]!=0)
				return false;

		}
	}
	return true;
}

bool TetrinetField::findPath(BlockStatus b, int x, int y, int *path, int xdir)
{
	path[0]=x;
	path[1]=y;
	
	if(x==b.x && y==b.y)
	{
		path[0]= -1796;
		return true;
	}

	// sanity
	if(!canPlace(b.type, b.x, b.y, false))
	{
		//cout << "findPath() abort\n";
		return false;
	}

	//cout << "Movement: " << x << "," << y << endl;
	// can we move up?
	if(y>b.y)
		if(canPlace(b.type, x, y-1, false))
			if(findPath(b, x, y-1, path+2, 0))
				return true;
	if(xdir!= -1)
		if(canPlace(b.type, x+1, y, false))
			if(findPath(b, x+1, y, path+2, 1))
				return true;
	if(xdir!=1)
		if(canPlace(b.type, x-1, y, false))
			if(findPath(b, x-1, y, path+2, -1))
				return true;
	path[0]= -1;
	return false;
}

int TetrinetField::getInaccessable()
{
	int iheight=getHeight();
	int wheight=TC_FIELD_HEIGHT-iheight;
	int inaccessable=0;
	for(int x=0;x<TC_FIELD_WIDTH;x++)
	{
		bool foundBlocks=false;
		for(int y=wheight;y<TC_FIELD_HEIGHT;y++)
		{
			if(field[y*TC_FIELD_WIDTH+x]!=0)
			{
				foundBlocks=true;
			}
			else if(foundBlocks>0)
			{
				inaccessable++;
			}
		}
	}
	return inaccessable;
}


void TetrinetField::getStats(int *height, int *heightSd, int *minHeight, int *totalTrough, int *numTrough, int *deepestTrough)
{
	int iheight=getHeight();
	int wheight=TC_FIELD_HEIGHT-iheight;
	int maxHeight[TC_FIELD_WIDTH];
	int minH=88888;
	for(int x=0;x<TC_FIELD_WIDTH;x++)
	{
		maxHeight[x]=0;
		for(int y=wheight;y<TC_FIELD_HEIGHT;y++)
		{
			if(field[y*TC_FIELD_WIDTH+x]!=0)
			{
				maxHeight[x]=TC_FIELD_HEIGHT-y;
				if(minH>maxHeight[x])
					minH=maxHeight[x];
				y=TC_FIELD_HEIGHT+1;
			}
		}
	}
	int iheightSd=0;
	for(int x=1;x<TC_FIELD_WIDTH;x++)
	{
		iheightSd+=abs(maxHeight[x]-maxHeight[x-1]);
	}
	int tt=0;
	int tnumTrough=0;
	int maxDepth=0;
	for(int x=0;x<TC_FIELD_WIDTH;x++)
	{
		int prev,next,me,depth;
		if(x!=0)
			prev=maxHeight[x-1];
		else
			prev=maxHeight[x+1];
		if(x!=(TC_FIELD_WIDTH-1))
			next=maxHeight[x+1];
		else
			next=maxHeight[x-1];
		me=maxHeight[x];
		if(((prev-me)>2) && ((next-me)>2))
		{
			int pt=prev-me;
			int nt=next-me;
			int fi;
			if(pt<nt)
				fi=pt;
			else
				fi=nt;
			tt+=fi;
			if(fi>maxDepth)
				maxDepth=fi;
			tnumTrough++;
		}
	}
	*totalTrough=tt;
	*deepestTrough=maxDepth;
	*numTrough=tnumTrough;
	*height=iheight;
	*heightSd=iheightSd;
	*minHeight=minH;
}

int TetrinetField::getHeight()
{
	// FIXME: check that we're divisible by 4 first!
	int *ifield=(int *)field;
	int estart=(TC_FIELD_WIDTH-(TC_FIELD_WIDTH&3));
	int extra=TC_FIELD_WIDTH&3;
	for(int y=0;y<TC_FIELD_HEIGHT;y++)
	{
		for(int x=0;x<(TC_FIELD_WIDTH>>2);x++)
		{
			if(ifield[y*(TC_FIELD_WIDTH>>2)+x]!=0)
				return TC_FIELD_HEIGHT-y;
		}
		for(int x=estart;x<TC_FIELD_WIDTH;x++)
		{
			if(field[y*TC_FIELD_WIDTH+x]!=0)
				return TC_FIELD_HEIGHT-y;
		}
	}
	return 0;
}

int TetrinetField::simulateDrop(BlockStatus b, int x)
{
	if(b.type<=0)
		return -1;

	if(!canPlace(b.type, x, 0, false))
		return -1;
	int y=1;
	// compiler should optimize, but deosn't always...
	int i=cxmin[b.type];
	int j=cxmax[b.type];


	while(true)
	{
		// check if we will hit anything if we drop here
		for(int cx= i; cx<=j ;cx++)
		{
			int cy=y+gravitymap[b.type][cx];
			if(gravitymap[b.type][cx]!=0)
			{
				if(cy>=TC_FIELD_HEIGHT)
					return placeBlock(b, x, y);
				if(field[(cy*TC_FIELD_WIDTH) + (x+cx)]!=0)
					return placeBlock(b, x, y);
			}
		}
		y++;
	}
}

int TetrinetField::placeBlock(BlockStatus b, int x, int y)
{
	// sanity check
	if(y<0)
		return 0;
	for(int cy=0;cy<4;cy++)
	{
		for(int cx= 0; cx< 4;cx++)
		{
			if(blockmap[b.type][cy*4+cx]!=0)
				field[((y+cy)*TC_FIELD_WIDTH) + (x+cx)]=blockmap[b.type][cy*4+cx];
		}
	}

	if(y>(TC_FIELD_HEIGHT-4))
		y=TC_FIELD_HEIGHT-4;

	int lines=0;
	for(int cy=y;cy<(y+4);cy++)
	{
		bool isLine=true;
		for(int x=0;x<TC_FIELD_WIDTH;x++)
		{
			if(field[cy*TC_FIELD_WIDTH+x]==0)
			{
				isLine=false;
				x=TC_FIELD_WIDTH;
			}
		}
		if(isLine)
		{
			// set each line to the one above it
			for(int l=cy;l>0;l--)
			{
				for(int x=0;x<TC_FIELD_WIDTH;x++)
					field[l*TC_FIELD_WIDTH+x]=field[(l-1)*TC_FIELD_WIDTH+x];
			}
			// clear the top line
			for(int x=0;x<TC_FIELD_WIDTH;x++)
				field[x]=0;
			lines++;
			cy--;
		}
	}
	return lines;
}

bool TetrinetField::canPlace(int b, int x, int y, bool gravity)
{
	// do the gravity test first, since it is more likely to fail...
	// check gravity - we do this by increasing y, and checking if we *don'T* hit a block
	if(gravity)
	{
		for(int cx= cxmin[b]; cx<=cxmax[b] ;cx++)
		{
			int cy=y+gravitymap[b][cx];
			if(gravitymap[b][cx]!=0)
			{
				// we chan check x extents here
				if((x+cx)<0 || (x+cx)>=TC_FIELD_WIDTH)
					return false;
				if(cy>=TC_FIELD_HEIGHT)
					goto gravOk;
				if(gravitymap[b][cx]!=0 && field[(cy*TC_FIELD_WIDTH) + (x+cx)]!=0)
					goto gravOk;
			}
		}
		return false;
gravOk:
		gravity=false;
	}
#include "checkBlocks.h"
	if(x>TC_FIELD_WIDTH)
		abort();
	return true;
}

TetrinetField::~TetrinetField()
{
	free(field);
}

void TetrinetField::printField()
{
	for(int y=0;y<TC_FIELD_HEIGHT;y++)
	{
		for(int x=0;x<TC_FIELD_WIDTH;x++)
		{
			if(field[y*TC_FIELD_WIDTH+x]==0)
				cout << ".";
			else
				printf("%c", field[y*TC_FIELD_WIDTH+x]+'a');
		}
		cout << endl;
	}
}
