#define MAX_MOVES 70

/* one result after doing specified moves and dropping the piece */
typedef struct move_result {
  signed char field[TC_FIELD_SIZE];        /* the resultant field */
  signed char specials[MAX_SPECIALS + 1];  /* the resultant specials */
  int         score;                       /* the score of the field */
  int         move_count;
  signed char moves[MAX_MOVES];            /* moves taken */
} MOVE_RESULT;

void init_beth_move();
MOVE_RESULT **find_moves(signed char *field, signed char *specials,
                         int block, int orient, int bx, int by);
MOVE_RESULT *find_best_move(signed char *field, signed char *specials,
                            int block, int orient, int bx, int by);
int find_best_move_score(signed char *field, signed char *specials,
                         int block, int orient, int bx, int by);
