/*  Copyright (C) 2011 Christopher Yeoh <cyeoh@au1.ibm.com>, IBM Corp. */

#define __USE_MISC
#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <sys/uio.h>

#include "process_vm.h"

#define DEFAULT_CHAR 53
#define PADDING_SIZE 10


int main(int argc, char *argv[])
{
  int val;
  int pid;
  char *addr;
  unsigned long len;
  unsigned char *buf;
  int j, i;
  struct iovec local, remote;

  if (argc!=4) {
    printf("%s <pid> <address> <length>\n", argv[0]);
    exit(1);
  }

  pid = atoi(argv[1]);
  sscanf(argv[2], "%p", &addr);
  len = atol(argv[3]);

  buf = malloc(len + PADDING_SIZE * 2);
  if (buf==NULL) {
    perror("malloc failed\n");
    printf("Failed to allocate %lu bytes\n", len + PADDING_SIZE * 2);
    exit(1);
  }

  for (j=0; j<len + PADDING_SIZE*2; j++) {
    buf[j] = DEFAULT_CHAR;
  }

  for (i=0; i<len; i++) {
    buf[i + PADDING_SIZE] = i % 256;
  }

  printf("Writing buffer to process: %i address %p length %lu\n", pid, addr, len);

  local.iov_base = buf + PADDING_SIZE;
  local.iov_len = len;
  remote.iov_base = addr;
  remote.iov_len = len;

  val = process_vm_writev(pid, &local, 1, &remote, 1, 0);

  if (val!=len) {
    perror("copy_from_to failed"); 
    printf("error code: %i\n", errno);
  } else {
  }

  return 0;

}
