/*  Copyright (C) 2011 Christopher Yeoh <cyeoh@au1.ibm.com>, IBM Corp. */

#define __USE_MISC
#include <sys/uio.h>
#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

#include "process_vm.h"

#define DEFAULT_CHAR 53
#define PADDING_SIZE 10
#define NUM_LOCAL_VECS 4

int main(int argc, char *argv[])
{
  int val;
  int pid;
  int j;
  struct iovec local[NUM_LOCAL_VECS];
  struct iovec *remote;
  unsigned long num_iovecs;
  int i;
  int rcv_buf_size;
  int rcv_buf_size_total = 0;
  int rcv_buf_size_left;

  srand(time(NULL));

  if (argc<4) {
    printf("%s <pid> <num_iovecs> <address> <length> <address> <length> <address> <length> ....\n", argv[0]);
    exit(1);
  }

  pid = atoi(argv[1]);
  num_iovecs = atol(argv[2]);

  remote = malloc(num_iovecs * sizeof(struct iovec));
  if (remote==NULL) {
    perror("malloc failed");
    exit(1);
  }
  
  for (i=3, j=0; i<num_iovecs*2 + 3; i+=2, j++) {
    if (i>=argc-1) {
      printf("Insufficient number of arguments %i %lu\n", i, num_iovecs);
      exit(1);
    }
    
    sscanf(argv[i], "%p", &remote[j].iov_base);
    remote[j].iov_len = atol(argv[i+1]);
    rcv_buf_size_total += remote[j].iov_len;
  }

  rcv_buf_size_left = rcv_buf_size_total;

  for (j=0; j<NUM_LOCAL_VECS-1; j++) {
    rcv_buf_size = rand() % (rcv_buf_size_left / 2) + 1;
    local[j].iov_base = malloc(rcv_buf_size);
    local[j].iov_len = rcv_buf_size;
    rcv_buf_size_left -= rcv_buf_size;
  }
  local[NUM_LOCAL_VECS-1].iov_base = malloc(rcv_buf_size_left);
  local[NUM_LOCAL_VECS-1].iov_len = rcv_buf_size_left;


  val = process_vm_readv(pid, local, NUM_LOCAL_VECS, remote, num_iovecs, 0);

  if (val!=rcv_buf_size_total) {
    perror("process_vm_readv failed"); 
    printf("error code: %i\n", errno);
  } else {
    int i;
    int num_errors = 0;
    int count = 0;

    for (i=0; i<NUM_LOCAL_VECS; i++) {
      for (j=0; j<local[i].iov_len; j++, count++) {
	if (((unsigned char *)local[i].iov_base)[j] != count % 256) {
	  printf("Expected %i, got %i for byte %i\n",
		 count % 256, ((char*)local[i].iov_base)[j], count);
	  num_errors++;
	}
      }
    }
	
    if (num_errors) {
      printf("*************** %i incorrect bytes\n", num_errors);
    } else {
      printf("Test succeeded\n");
    }

  }

  return 0;

}
