#ifndef _PROCESS_VM_H
#define _PROCESS_VM_H


#define _GNU_SOURCE
#include <unistd.h>
#include <sys/syscall.h>
#include <sys/types.h>

#if defined(i386)
#define __NR_process_vm_readv 347
#define __NR_process_vm_writev 348


#elif defined(_ARCH_PPC)
#define __NR_process_vm_readv 351
#define __NR_process_vm_writev 352


#else
#error "Need to define syscall numbers for process_vm_readv and process_vm_writev for this architecture "
#endif



inline ssize_t process_vm_readv(pid_t pid, 
				const struct iovec  *lvec, 
				unsigned long liovcnt,
				const struct iovec *rvec,
				unsigned long riovcnt,
				unsigned long flags)
{
  return syscall(__NR_process_vm_readv, pid, lvec, liovcnt, rvec, riovcnt, flags);
}

ssize_t process_vm_writev(pid_t pid, 
			  const struct iovec  *lvec, 
			  unsigned long liovcnt,
			  const struct iovec *rvec,
			  unsigned long riovcnt,
			  unsigned long flags)
{
  return syscall(__NR_process_vm_writev, pid, lvec, liovcnt, rvec, riovcnt, flags);
}



#endif /* _PROCESS_VM_H */
