/*  Copyright (C) 2011 Christopher Yeoh <cyeoh@au1.ibm.com>, IBM Corp. */

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <stdlib.h>

unsigned char *foo;
int buffer_size = 100000;

#define DEFAULT_CHAR 53
#define PADDING_SIZE 10


int main(int argc, char *argv[])
{
  int i = 0, num_errors = 0;
  pid_t pid;

  if (argc>2) {
    printf("Usage: %s <buffer_size>\n", argv[0]);
    exit(1);
  } else if (argc==2) {
    buffer_size = atoi(argv[1]);
  }
  printf("Using test buffer size %i\n", buffer_size);


  pid = fork();
  if (pid!=0) exit(0);

  foo = malloc(buffer_size);
  if (foo==NULL) {
    perror("Malloc failed");
    exit(1);
  }

  for (i=0; i<buffer_size; i++) {
    foo[i] = DEFAULT_CHAR;
  }

  printf("Target process is setup\nRun the following to test:\n./t_process_vm_writev ");
  printf("%i %p %i\n", getpid(), foo, buffer_size);
  while (foo[buffer_size-1]==DEFAULT_CHAR)
    {
      sleep(1);
    }

  for (i=0; i<buffer_size; i++) {
    if (foo[i] != i % 256) {
      printf("Expected %i, got %i for byte %i\n",
	     i % 256, foo[i], i);
      num_errors++;
    }
  }

  if (num_errors==0) {
    printf("Test passed\n");
    exit(0);
  } else {
    printf("Test failed - %i errors\n", num_errors);
    exit(1);
  }
}
