/*  Copyright (C) 2011 Christopher Yeoh <cyeoh@au1.ibm.com>, IBM Corp. */

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <stdlib.h>
#include <time.h>

char **foo;
int *buf_sizes;

int buffer_size = 100000;
int num_iovecs = 10;
int buffer_left;
int new_buf_size;
int count;

int main(int argc, char *argv[])
{
  int i = 0, j;

  if (argc!=3 && argc!=1) {
    printf("Usage: %s <num_iovecs> <buffer_size>\n", argv[0]);
    exit(1);
  }

  if (argc!=1) {
    buffer_size = atoi(argv[2]);
    num_iovecs = atoi(argv[1]);
  }


  pid_t pid;

  pid = fork();
  
  if (pid!=0) {
    exit(0);
  }

  srand(time(NULL));

  printf("Setting up target with num iovecs %i, test buffer size %i\n", num_iovecs, buffer_size);

  buffer_left = buffer_size;

  foo = malloc(num_iovecs * sizeof(char *));
  if (foo==NULL) {
    perror("Malloc failed");
    exit(1);
  }
  buf_sizes = malloc(num_iovecs * sizeof(int *));
  
  for (i=0; i<num_iovecs-1; i++) {
    new_buf_size = rand() % (buffer_left / 2) + 1;
    foo[i] = malloc(new_buf_size);
    if (foo[i]==NULL) {
      perror("Malloc failed");
      exit(1);
    }
    buf_sizes[i] = new_buf_size;
    buffer_left -= new_buf_size;
  }
  buf_sizes[num_iovecs-1] = buffer_left;
  foo[num_iovecs-1] = malloc(buffer_left);
  if (foo[num_iovecs-1]==NULL) {
    perror("Malloc failed");
    exit(1);
  }

  count = 0;
  for (i=0; i<num_iovecs; i++) {
    for (j=0; j<buf_sizes[i]; j++, count++) {
      foo[i][j] = count % 256;
    }
  }

  printf("Target process is setup\nRun the following to test:\n./t_process_vm_readv_iovec ");
  printf("%i %i", getpid(), num_iovecs);
  for (i=0; i<num_iovecs; i++) {
    printf(" %p %i", foo[i], buf_sizes[i]);
  }
  printf("\n");



  while (1)
    {
      sleep(100);
    }
}
